% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_FSCORE.R
\name{do.fscore}
\alias{do.fscore}
\title{Fisher Score}
\usage{
do.fscore(X, label, ndim = 2, preprocess = c("null", "center", "whiten",
  "decorrelate"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null" and other options of "center", "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Fisher Score (FSCORE) is a supervised linear feature extraction method. For each
feature/variable, it computes Fisher score, a ratio of between-class variance to within-class variance.
The algorithm selects variables with largest Fisher scores and returns an indicator projection matrix.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## compare Fisher score with LDA
out1 = do.lda(X, label)
out2 = do.fscore(X, label)

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="LDA")
plot(out2$Y[,1], out2$Y[,2], main="Fisher Score")
}

}
\references{
\insertRef{fisher_use_1936}{Rdimtools}
}
\author{
Kisung You
}
