% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PPCA.R
\name{do.ppca}
\alias{do.ppca}
\title{Probabilistic Principal Component Analysis}
\usage{
do.ppca(X, ndim = 2, preprocess = c("center", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
``center'' (default),``decorrelate'', or ``whiten''. See also \code{\link{aux.preprocess}}
for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are principal components.}
\item{mle.sigma2}{MLE for \eqn{\sigma^2}.}
\item{mle.W}{MLE of a \eqn{(p\times ndim)} mapping from latent to observation in column major.}
}
}
\description{
Probabilistic PCA (PPCA) is a probabilistic framework to explain the well-known PCA model. Using
the conjugacy of normal model, we compute MLE for values explicitly derived in the paper. Note that
unlike PCA where loadings are directly used for projection, PPCA uses \eqn{WM^{-1}} as projection matrix,
as it is relevant to the error model. Also, for high-dimensional problem, it is possible that MLE can have
negative values if sample covariance given the data is rank-deficient.
}
\examples{
\dontrun{
## generate data
X <- aux.gensamples(n=496)

## Compare PCA and PPCA
PCA  <- do.pca(X, ndim=2, preprocess="center")
PPCA <- do.ppca(X, ndim=2, preprocess="center")

## Visualize
par(mfrow=c(1,2))
plot(PCA$Y[,1], PCA$Y[,2], main="PCA")
plot(PPCA$Y[,1], PPCA$Y[,2], main="PPCA")
}

}
\references{
\insertRef{tipping_probabilistic_1999}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
