% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MMC.R
\name{do.mmc}
\alias{do.mmc}
\title{Maximum Margin Criterion}
\usage{
do.mmc(X, label, ndim = 2, preprocess = c("center", "decorrelate",
  "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and two other options "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Maximum Margin Criterion (MMC) is a linear supervised dimension reduction method that
maximizes average margin between classes. The cost function is defined as
\deqn{trace(S_b - S_w)}
where \eqn{S_b} is an overall variance of class mean vectors, and \eqn{S_w} refers to
spread of every class. Note that Principal Component Analysis (PCA) maximizes
total scatter, \eqn{S_t = S_b + S_w}.
}
\examples{
## generate 3 different groups of data X and label vector
x1 = matrix(rnorm(4*10), nrow=10)-20
x2 = matrix(rnorm(4*10), nrow=10)
x3 = matrix(rnorm(4*10), nrow=10)+20
X  = rbind(x1, x2, x3)
label = c(rep(1,10), rep(2,10), rep(3,10))

## perform MVP with different preprocessings
out1 = do.mmc(X, label, ndim=2)
out2 = do.mmc(X, label, ndim=2, preprocess="decorrelate")

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="centering")
plot(out2$Y[,1], out2$Y[,2], main="decorrelating")

}
\references{
\insertRef{li_efficient_2006}{Rdimtools}
}
\author{
Kisung You
}
