% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_CRDA.R
\name{do.crda}
\alias{do.crda}
\title{Curvilinear Distance Analysis}
\usage{
do.crda(X, ndim = 2, type = c("proportion", 0.1), symmetric = "union",
  weight = TRUE, lambda = 1, alpha = 1, maxiter = 1000,
  tolerance = 1e-06)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform CRDA on weighted graph, or \code{FALSE} otherwise.}

\item{lambda}{threshold value.}

\item{alpha}{initial value for updating.}

\item{maxiter}{maximum number of iterations allowed.}

\item{tolerance}{stopping criterion for maximum absolute discrepancy between two distance matrices.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{niter}{the number of iterations until convergence.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Curvilinear Distance Analysis (CRDA) is a variant of Curvilinear Component Analysis in that
the input pairwise distance is altered by curvilinear distance on a data manifold.
Like in Isomap, it first generates \emph{neighborhood graph} and finds \emph{shortest path} on
a constructed graph so that the shortest-path length plays as an approximate geodesic distance on
nonlinear manifolds.
}
\examples{
\dontrun{
## generate sample data
X <- aux.gensamples(n=200)

## weighted versus binary graph construction
out1 <- do.crda(X,weight=TRUE)
out2 <- do.crda(X,weight=FALSE)

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1],out1$Y[,2],main="weighted graph")
plot(out2$Y[,1],out2$Y[,2],main="binarized graph")
}

}
\references{
\insertRef{lee_curvilinear_2002}{Rdimtools}

\insertRef{lee_nonlinear_2004}{Rdimtools}
}
\seealso{
\code{\link{do.isomap}}, \code{\link{do.crca}}
}
\author{
Kisung You
}
