% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LPE.R
\name{do.lpe}
\alias{do.lpe}
\title{Locality Pursuit Embedding}
\usage{
do.lpe(X, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), numk = max(ceiling(nrow(X)/10), 2))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{numk}{size of \eqn{k}-nn neighborhood in original dimensional space.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locality Pursuit Embedding (LPE) is an unsupervised linear dimension reduction method.
It aims at preserving local structure by solving a variational problem that models
the local geometrical structure by the Euclidean distances.
}
\examples{
\dontrun{
## generate swiss roll with auxiliary dimensions
n = 100
theta = runif(n)
h     = runif(n)
t     = (1+2*theta)*(3*pi/2)
X     = array(0,c(n,10))
X[,1] = t*cos(t)
X[,2] = 21*h
X[,3] = t*sin(t)
X[,4:10] = matrix(runif(7*n), nrow=n)

## try with different neighborhood sizes
out1 = do.lpe(X, numk=5)
out2 = do.lpe(X, numk=10)
out3 = do.lpe(X, numk=25)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="LPE::numk=5")
plot(out2$Y[,1], out2$Y[,2], main="LPE::numk=10")
plot(out3$Y[,1], out3$Y[,2], main="LPE::numk=25")
}

}
\references{
\insertRef{min_locality_2004}{Rdimtools}
}
\author{
Kisung You
}
