% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KMFA.R
\name{do.kmfa}
\alias{do.kmfa}
\title{Kernel Marginal Fisher Analysis}
\usage{
do.kmfa(X, label, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), k1 = max(ceiling(nrow(X)/10), 2),
  k2 = max(ceiling(nrow(X)/10), 2), t = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{k1}{the number of same-class neighboring points (homogeneous neighbors).}

\item{k2}{the number of different-class neighboring points (heterogeneous neighbors).}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Kernel Marginal Fisher Analysis (KMFA) is a nonlinear variant of MFA using kernel tricks.
For simplicity, we only enabled a heat kernel of a form
\deqn{k(x_i,x_j)=\exp(-d(x_i,x_j)^2/2*t^2)}
where \eqn{t} is a bandwidth parameter. Note that the method is far sensitive to the choice of \eqn{t}.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different numbers for neighborhood size
out1 = do.kmfa(X, label, k1=5, k2=5, t=1)
out2 = do.kmfa(X, label, k1=5, k2=5, t=2)

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="bandwidth=1")
plot(out2$Y[,1], out2$Y[,2], main="bandwidth=2")
}
}
\references{
\insertRef{yan_graph_2007}{Rdimtools}
}
\author{
Kisung You
}
