% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_DM.R
\name{do.dm}
\alias{do.dm}
\title{Diffusion Maps}
\usage{
do.dm(X, ndim = 2, preprocess = c("null", "center", "scale", "cscale",
  "decorrelate", "whiten"), bandwidth = 1, timescale = 1,
  multiscale = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{bandwidth}{a scaling parameter for diffusion kernel. Default is 1 and should be a nonnegative real number.}

\item{timescale}{a target scale whose value represents behavior of heat kernels at time \emph{t}. Default is 1 and should be a positive real number.}

\item{multiscale}{logical; \code{FALSE} is to use the fixed \code{timescale} value, \code{TRUE} to ignore the given value.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{eigvals}{a vector of eigenvalues for Markov transition matrix.}
}
}
\description{
\code{do.dm} discovers low-dimensional manifold structure embedded in high-dimensional
data space using Diffusion Maps (DM). It exploits diffusion process and distances in data space to find
equivalent representations in low-dimensional space.
}
\examples{
\dontrun{
## generate swiss roll data
X <- aux.gensamples(n=200)

## compare different bandwidths
out1 <- do.dm(X,bandwidth=10)
out2 <- do.dm(X,bandwidth=100)
out3 <- do.dm(X,bandwidth=1000)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="DM::bandwidth=10")
plot(out2$Y[,1],out2$Y[,2],main="DM::bandwidth=100")
plot(out3$Y[,1],out3$Y[,2],main="DM::bandwidth=1000")
}

}
\references{
\insertRef{nadler_diffusion_2005}{Rdimtools}

\insertRef{coifman_diffusion_2006}{Rdimtools}
}
\author{
Kisung You
}
