% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_DISR.R
\name{do.disr}
\alias{do.disr}
\title{Diversity-Induced Self-Representation}
\usage{
do.disr(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  lbd1 = 1,
  lbd2 = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{lbd1}{nonnegative number to control the degree of self-representation.}

\item{lbd2}{nonnegative number to control the degree of feature similarity.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Diversity-Induced Self-Representation (DISR) is a feature selection method that aims at
ranking features by both representativeness and diversity. Self-representation controlled by
\code{lbd1} lets the most representative features to be selected, while \code{lbd2} penalizes
the degree of inter-feature similarity to enhance diversity from the chosen features.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

#### try different lbd combinations
out1 = do.disr(X, lbd1=1, lbd2=1)
out2 = do.disr(X, lbd1=1, lbd2=5)
out3 = do.disr(X, lbd1=5, lbd2=1)
out4 = do.disr(X, lbd1=5, lbd2=5)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(out1$Y, main="(lbd1,lbd2)=(1,1)", col=label, pch=19, cex=0.5)
plot(out2$Y, main="(lbd1,lbd2)=(1,5)", col=label,pch=19, cex=0.5)
plot(out3$Y, main="(lbd1,lbd2)=(5,1)", col=label,pch=19, cex=0.5)
plot(out4$Y, main="(lbd1,lbd2)=(5,5)", col=label,pch=19, cex=0.5)
par(opar)
}

}
\references{
\insertRef{liu_unsupervised_2017}{Rdimtools}
}
\seealso{
\code{\link{do.rsr}}
}
\author{
Kisung You
}
