% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LDAKM.R
\name{do.ldakm}
\alias{do.ldakm}
\title{Combination of LDA and K-means}
\usage{
do.ldakm(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  maxiter = 10,
  abstol = 0.001
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{maximum number of iterations allowed.}

\item{abstol}{stopping criterion for incremental change in projection matrix.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
\code{do.ldakm} is an unsupervised subspace discovery method that combines linear discriminant analysis (LDA) and K-means algorithm.
It tries to build an adaptive framework that selects the most discriminative subspace. It iteratively applies two methods in that
the clustering process is integrated with the subspace selection, and continuously updates its discrimative basis. From its formulation
with respect to generalized eigenvalue problem, it can be considered as generalization of Adaptive Subspace Iteration (ASI) and Adaptive Dimension Reduction (ADR).
}
\examples{
## generate swiss roll data
X = aux.gensamples(n=123)

## try different tolerance level
out1 = do.ldakm(X, abstol=1e-2)
out2 = do.ldakm(X, abstol=1e-3)
out3 = do.ldakm(X, abstol=1e-4)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="LDA-KM::tol=1e-2")
plot(out2$Y, main="LDA-KM::tol=1e-3")
plot(out3$Y, main="LDA-KM::tol=1e-4")
par(opar)

}
\references{
\insertRef{ding_adaptive_2007}{Rdimtools}
}
\seealso{
\code{\link{do.asi}}, \code{\link{do.adr}}
}
\author{
Kisung You
}
\concept{linear_methods}
