% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_RLDA.R
\name{do.rlda}
\alias{do.rlda}
\title{Regularized Linear Discriminant Analysis}
\usage{
do.rlda(X, label, ndim = 2, alpha = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{alpha}{Tikhonow regularization parameter.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
In small sample case, Linear Discriminant Analysis (LDA) may suffer from
rank deficiency issue. Applied mathematics has used Tikhonov regularization -
also known as \eqn{\ell_2} regularization/shrinkage - to adjust linear operator.
Regularized Linear Discriminant Analysis (RLDA) adopts such idea to stabilize
eigendecomposition in LDA formulation.
}
\examples{
\dontrun{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different regularization parameters
out1 <- do.rlda(X, label, alpha=0.001)
out2 <- do.rlda(X, label, alpha=0.01)
out3 <- do.rlda(X, label, alpha=100)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="RLDA::alpha=0.1")
plot(out2$Y, col=label, main="RLDA::alpha=1")
plot(out3$Y, col=label, main="RLDA::alpha=10")
par(opar)
}

}
\references{
\insertRef{friedman_regularized_1989}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
