% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ver2_linear_FA.R
\name{do.fa}
\alias{do.fa}
\title{Exploratory Factor Analysis}
\usage{
do.fa(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  maxiter = 1000,
  tolerance = 1e-06
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued number of loading variables, or target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"center"}. See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{maximum number of iterations for updating.}

\item{tolerance}{stopping criterion in a Frobenius norm.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{loadings}{a \eqn{(p\times ndim)} matrix whose rows are extracted loading factors.}
\item{noise}{a length-\eqn{p} vector of estimated noise.}
}
}
\description{
\code{do.fa} is an optimization-based implementation of a popular technique for Exploratory Data Analysis.
It is closely related to principal component analysis.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## try different preprocessing procedure
out1 <- do.fa(X,ndim=2)
out2 <- do.fa(X,ndim=2,preprocess="decorrelate")
out3 <- do.fa(X,ndim=2,preprocess="whiten")

## extract embeddings for each procedure
Y1 <- out1$Y; Y2 <- out2$Y; Y3 <- out3$Y

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(Y1, pch=19, col=lab, main="FA::centered")
plot(Y2, pch=19, col=lab, main="FA::decorrelated")
plot(Y3, pch=19, col=lab, main="FA::whitened")
par(opar)
}

}
\references{
\insertRef{spearman_general_1904}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
