% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_PROCRUSTES.R
\name{do.procrustes}
\alias{do.procrustes}
\title{Feature Selection using PCA and Procrustes Analysis}
\usage{
do.procrustes(
  X,
  ndim = 2,
  intdim = (ndim - 1),
  cor = TRUE,
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{intdim}{intrinsic dimension of PCA to be applied. It should be smaller than \code{ndim}.}

\item{cor}{mode of eigendecomposition. \code{FALSE} for decomposing covariance, and \code{TRUE} for correlation matrix in PCA.}

\item{preprocess}{an additional option for preprocessing the data. Default is \code{"center"}. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
\code{do.procrustes} selects a set of features that best aligns PCA's coordinates in the embedded low dimension.
It iteratively selects each variable that minimizes Procrustes distance between configurations.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
iris.dat = as.matrix(iris[,1:4])
iris.lab = as.factor(iris[,5])

## try different strategy
out1 = do.procrustes(iris.dat, cor=TRUE)
out2 = do.procrustes(iris.dat, cor=FALSE)
out3 = do.mifs(iris.dat, iris.lab, beta=0)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1, 3))
plot(out1$Y, pch=19, col=iris.lab, main="PCA with Covariance")
plot(out2$Y, pch=19, col=iris.lab, main="PCA with Correlation")
plot(out3$Y, pch=19, col=iris.lab, main="MIFS")
par(opar)
}

}
\references{
\insertRef{krzanowski_selection_1987a}{Rdimtools}
}
\author{
Kisung You
}
\concept{feature_methods}
