% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.constant.R
\name{integration.constant}
\alias{integration.constant}
\title{Compute the integration constant for distance density functions}
\usage{
integration.constant(dist, density, a, covars, w.lo, w.hi, series,
  expansions, pointSurvey)
}
\arguments{
\item{dist}{Vector of detection distance values.}

\item{density}{A likelihood function for which the
integration constant is sought. This function
must be capable of evaluating values between \code{w.lo}
and \code{w.hi} and have the following parameters:
    \itemize{
      \item \samp{a} = Parameter vector.
      \item \samp{dist} = Vector of distances.
      \item \samp{covars} = If the density allows covariates, 
      the covariate matrix.
      \item \samp{w.lo} = Lower limit or left truncation value.
      \item \samp{w.hi} = Upper limit or right truncation value.
      \item \samp{series} = Form of the series expansions, if any.
      \item \samp{expansions} = Number of expansion terms.
      \item \samp{scale} = Whether to scale function to integrate to 1.
    }}

\item{a}{Vector of parameters to pass to \code{density}.}

\item{covars}{Matrix of covariate values.}

\item{w.lo}{The lower limit of integration, or the left truncation
value for perpendicular distances.}

\item{w.hi}{The upper limit of integration, or the right truncation
value for perpendicular distances.}

\item{series}{The series to use for expansions. 
If \code{expansions} > 0, this string 
specifies the type of expansion. Valid values at 
present are 'simple', 'hermite', and 'cosine'.}

\item{expansions}{Number of expansions in \code{density}.}

\item{pointSurvey}{Boolean. TRUE if point transect data,
FALSE if line transect data.}
}
\value{
A scalar (or vector of scalars if covariates are present)
that is the area under \code{density} between \code{w.lo} and \code{w.hi}.
This scalar can be used as a divisor to scale density such that
it integrates to 1.0. If x = density(\ldots), then
x / \code{integration.constant(density, \ldots)} will integrate to 1.0.
}
\description{
Using numerical integration, this function computes
the area under a distance function between two limits (\code{w.lo}
and \code{w.hi}).
}
\details{
The trapezoid rule is used to numerically integrate
\code{density} from \code{w.lo} to \code{w.hi}. Two-hundred
(200) equal-sized trapezoids are used in the integration.  The number
of trapezoids to use is fixed and cannot be changed without
re-writing this routine.
}
\examples{
# Can put any number for first argument (1 used here)
scl <- integration.constant(dist=1, density=uniform.like, covars = NULL,
                            pointSurvey = FALSE, w.lo=0, w.hi = 100,
                            expansions = 0, a=c(75,25))
print(scl) # Should be 75.1

x <- seq(0,100,length=200)
y <- uniform.like( c(75,25), x, scale=FALSE ) / scl
int.y <- (x[2]-x[1]) * sum(y[-length(y)]+y[-1]) / 2  # the trapezoid rule, should be 1.0
print(int.y) # Should be 1

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{halfnorm.like}}
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}
        Aidan McDonald, WEST Inc.,  \email{aidan@mcdcentral.org}
        Michael Kleinsasser, WEST Inc.,  \email{mkleinsa@uwyo.edu}
}
\keyword{models}
