% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dfunc.r
\name{plot.dfunc}
\alias{plot.dfunc}
\title{Plot a distance (detection) function}
\usage{
\method{plot}{dfunc}(x, include.zero = FALSE, nbins = "Sturges",
  newdata = NULL, legend = TRUE, vertLines = TRUE, plotBars = TRUE,
  density = NULL, xlab = "Distance", ylab = if (x$pointSurvey)
  "Observation density" else "Probability of detection", border = "blue",
  col = 0, col.dfunc = "red", lty.dfunc = 1, lwd.dfunc = 2, ...)
}
\arguments{
\item{x}{An estimated distance function resulting from a call to
\code{dfuncEstim}.}

\item{include.zero}{Boolean value specifying whether to include 0 in the
plot.  A value of TRUE will include 0 on the left hand end of the x-axis
regardless of the range of distances.  A value of FALSE will plot only the
range on input distanced.}

\item{nbins}{Internally, this function uses \code{hist} to compute histogram
bars for the plot. This argument is the \code{breaks} argument to
\code{hist}.  This can be either a vector giving the breakpoints between
bars, a single number giving the suggested number of bars, a string naming
an algorithm to compute the number of bars, or a function to compute the
number of bars.  See \code{help(hist)} for all options.}

\item{newdata}{Matrix containing values of covariates to plot. Each row is a
set of covariate values (i.e. each column contains all values of each
covariate)}

\item{legend}{Logical scalar for whether to include legend. 
If TRUE, a legend will be included on plot detailing
covariate values plotted.}

\item{vertLines}{Logical scalar specifying whether to plot vertical 
lines at \code{w.lo} and \code{w.hi} from 0 to the  
distance function.}

\item{plotBars}{Logical scalar for whether to plot the histogram 
of distances behind the distance function.  If FALSE, no histogram 
is plotted, only the distance function line(s).}

\item{density}{If \code{plotBars=TRUE}, a vector giving the density of 
shading lines, in lines per inch, for the bars underneath 
the distance function. Values of NULL or a number strictly less than 0 
mean solid fill using colors from parameter \code{col}.  If 
\code{density =0 }, bars are not filled with any color or lines.}

\item{xlab}{Label for the x-axis}

\item{ylab}{Label for the y-axis}

\item{border}{The color of bar borders when bars are plotted. A 
value of NA means no borders. If there are shading lines 
(i.e., \code{density>0}), \code{border = TRUE} uses the same 
color for the border as for the shading lines.}

\item{col}{A vector of bar fill colors or line colors when bars are 
drawn and \code{density != 0}, replicated
to the correct length. A value of 0 is the background color.}

\item{col.dfunc}{Color of the distance function(s), replicated to 
the required length. If covariates or \code{newdata} is present 
and \code{length(col.dfunc)==1}, 
\code{col.dfunc} is expanded to 
to number of plotted distance functions by setting it equal 
to \code{graphics::rainbow(n)}, where \code{n} is the number 
of plotted distance functions.  If you want to plot all 
distance functions in the same color, set \code{col.dfunc} to
a constant vector having length at least 2 (e.g., 
\code{col.dfunc = c(1,1)}) will 
plot all curves in black).}

\item{lty.dfunc}{Line type of the distance function(s), replicated 
to the required length.  If covariates or \code{newdata} is present 
and \code{length(lty.dfunc)==1}, 
\code{lty.dfunc} is expanded to 
to number of plotted distance functions by setting it equal 
to \code{lty.dfunc + 0:(n-1)}, where \code{n} is the number 
of plotted distance functions.  If you want to plot all 
distance functions using the same line type, set \code{lty.dfunc} to
a constant vector having length at least 2 (e.g., 
\code{lty.dfunc = c(1,1)}) will 
plot all solid lines).}

\item{lwd.dfunc}{Line width of the distance function(s), replicated 
to the required length.}

\item{\dots}{When bars are plotted, this routine 
uses \code{graphics::barplot} for setting up the 
plotting region and plotting bars. When bars are not plotted,
this routine sets up the plot with \code{graphics::plot}.
\dots can be any other 
argument to \code{barplot} or \code{plot} EXCEPT  
\code{width}, \code{ylim}, \code{xlim}, and \code{space}.}
}
\value{
The input distance function is returned, with two additional
  components related to the plot that may be needed if additional lines or
  text is to added to the plot by the user.  These additional components are:
  
  \item{xscl.plot}{Scaling factor for horizontal coordinates.  Due to the way
  \code{barplot} works, the x-axis has been scaled.  The internal coordinates
  of the bars are 1, 2, \ldots, \code{nbars}. To plot something at a distance
  coordinate of x, x must be divided by this value.  For example, to draw a
  vertical line at a value of 10 on the x-axis, the correct call is
  \code{abline(v=10/obj$xscl.plot)}.  }
  
  \item{yscl}{Scaling factor for vertical coordinates.  The histogram and
  distance function plotted by this routine are scaled so that height of the
  distance function at \code{w.lo} is \code{g0}.  Usually, this means the
  distance curve is scaled so that the y-intercept is 1, or that g(0) = 1. 
  To add a plot feature at a real coordinate of y, y must be divided by this
  returned parameters.  For example, to draw a horizontal line at y-axis
  coordinate of 1.0, issue \code{abline(h=1/obj$yscl)}.  }
}
\description{
Plot method for an estimated distance function. Estimated
  distance functions are of class 'dfunc'
}
\details{
If \code{plotBars} is TRUE, a scaled histogram is plotted
 and the estimated distance function
  is plotted over the top of it.  When bars are plotted, 
  this routine uses \code{graphics::barplot} 
 for setting up the initial plotting region and
 most parameters to \code{graphics::barplot} can 
 be specified (exceptions noted above in description of '\dots').The form of the likelihood and any series
  expansions is printed in the main title (overwrite this with 
  \code{main="<my title>"}). Convergence of the distance
  function is checked.  If the distance function did not converge, a warning
  is printed over the top of the histogram.  If one or more parameter
  estimates are at their limits (likely indicating non-convergence or poor
  fit), another warning is printed.
}
\examples{
set.seed(87654)
x <- rnorm(1000, mean=0, sd=20)
x <- x[x >= 0]
dfunc <- dfuncEstim(x~1, likelihood="halfnorm")
plot(dfunc)
plot(dfunc, nbins=25)

# showing effects of plot params
plot(dfunc, col=c("red","blue","orange"), 
 border="black", xlab="Dist (m)", ylab="Prob", 
 vertLines = FALSE, main="Showing plot params")
 
plot(dfunc, col="wheat", density=30, angle=c(-45,0,45), 
cex.axis=1.5, cex.lab=2, ylab="Probability") 

plot(dfunc, col=c("grey","lightgrey"), border=NA) 

plot(dfunc, col="grey", border=0, col.dfunc="blue", 
lty.dfunc = 2, lwd.dfunc=4, vertLines=FALSE)

plot(dfunc, plotBars=FALSE, cex.axis=1.5, col.axis="blue") 
rug(dfunc$dist)

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{print.dfunc}},
  \code{\link{print.abund}}
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}\cr 
Aidan McDonald, WEST Inc.,  \email{aidan@mcdcentral.org}
}
\keyword{models}
