% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize.R
\name{colorize}
\alias{colorize}
\title{colorize - Add color to result if terminal accepts it}
\usage{
colorize(STR, col = NULL, bg = NULL)
}
\arguments{
\item{STR}{The string to colorize.}

\item{col}{A string specifying the desired foreground color.
This is passed straight to \code{crayon::style} and so must be 
recognized as one of the 8 base crayon colors. i.e., 
"black", "red", "green", "yellow", "blue", "magenta", "cyan", 
"white", and "silver" (silver = gray). By default, numbers 
are styled in "green".}

\item{bg}{A string specifying the desired background color. 
Must be one of "bgBlack", "bgRed", "bgGreen", "bgYellow", "bgBlue"
"bgMagenta", "bgCyan", or "bgWhite".  By default, no background 
is applied.}
}
\value{
If color is not allowed in the terminal, the input 
string is returned unperturbed.  If color is allowed, the input 
string is returned with color and background ANSI code surrounding 
the initial part of the string from character 1 to the character 
before the [ in the last pair of [].
}
\description{
Add ANSI color to a string using the 
\code{crayon} package, if the R environment accepts color. 
This function is needed because of the need to determine whether 
output can be colorized.  This determination is left up to 
\code{crayon::has_color()}. 

In addition, for Rdistance results, we want to only colorize 
numbers, not the reporting units.  Everything between the last set 
of square brackets (\code{[...]}) is NOT colorized.
}
\seealso{
\code{crayon::style}
}
