% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdrools.R
\name{executeRulesOnDataset}
\alias{executeRulesOnDataset}
\title{Run a set of rules on a dataset}
\usage{
executeRulesOnDataset(dataset, rules)
}
\arguments{
\item{dataset}{a data frame on which the defined set of rules should be applied}

\item{rules}{a data frame in which rules are defined}
}
\value{
A list of input, intermediate output and output per rule
  \enumerate{
  \item \strong{input}: a tibble containing the rules defined by the user
  \item \strong{intermediateOutput}: is an empty tibble when there is no group by condition specified, 
  and a tibble with the aggregated value for each group when it is
  \item \strong{output}: a tibble with 3 columns:
    \enumerate{
    \item \strong{Group}: represents group name when there is a group by condition specified and the 
    row number in the case that there is no group by condition
    \item \strong{Indices}: the row numbers corresponding to each group when there is a group by 
    specified and row numbers of the data frame in the case that there is no group by condition
    \item \strong{IsTrue}: flag indicating if the data point/ set of data points satisfies the rule 
    or not. Returns TRUE if the point or group satisfies the rule and FALSE if not.  
    }
   }
}
\description{
The \code{executeRulesOnDataset} function is an intuitive interface to execute rules on 
datasets, which is explicitly designed for data scientists. As input to this function rules are defined using the typical language of data science with verbs such as filter, group by and aggregate. Rules can be specified in a .csv file, loaded into the R session and passed to this function
}
\details{
The vignette provides further details on the format of the rules file
}
\examples{
\dontrun{
  library(Rdrools)
  data("iris")
  data("irisRules")
  executeRulesOnDataset(iris, irisRules)
  }
}
\seealso{
\code{\link{runRulesDrl}}, \code{\link{Rdrools}}

Other Interface Functions to Drools: \code{\link{rulesSessionDrl}},
  \code{\link{runRulesDrl}}
}
\author{
Dheekshitha PS < Dheekshitha.PS@mu-sigma.com>

Naren Srinivasan <Naren.Srinivasan@mu-sigma.com>

Mayukh Bose <Mayukh.Bose@mu-sigma.com>
}
