/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Operator
implements Externalizable,
org.drools.runtime.rule.Operator {
    private static final long serialVersionUID = 510L;
    private static final Map<String, Operator> CACHE = Collections.synchronizedMap(new HashMap());
    public static final Operator EQUAL = Operator.addOperatorToRegistry("==", false);
    public static final Operator NOT_EQUAL = Operator.addOperatorToRegistry("!=", false);
    public static final Operator LESS = Operator.addOperatorToRegistry("<", false);
    public static final Operator LESS_OR_EQUAL = Operator.addOperatorToRegistry("<=", false);
    public static final Operator GREATER = Operator.addOperatorToRegistry(">", false);
    public static final Operator GREATER_OR_EQUAL = Operator.addOperatorToRegistry(">=", false);
    private String operator;
    private boolean isNegated;

    public static Operator addOperatorToRegistry(String operatorId, boolean isNegated) {
        Operator op = new Operator(operatorId, isNegated);
        CACHE.put(Operator.getKey(operatorId, isNegated), op);
        return op;
    }

    public static Operator determineOperator(String operatorId, boolean isNegated) {
        Operator op = CACHE.get(Operator.getKey(operatorId, isNegated));
        return op;
    }

    private static String getKey(String string, boolean isNegated) {
        return isNegated + ":" + string;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operator = (String)in.readObject();
        this.isNegated = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.operator);
        out.writeBoolean(this.isNegated);
    }

    public Operator() {
    }

    private Operator(String operator, boolean isNegated) {
        this.operator = operator;
        this.isNegated = isNegated;
    }

    private Object readResolve() throws ObjectStreamException {
        return Operator.determineOperator(this.operator, this.isNegated);
    }

    public String toString() {
        return "Operator = '" + this.operator + "'";
    }

    public String getOperatorString() {
        return this.operator;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isNegated ? 1231 : 1237);
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        if (this.isNegated != other.isNegated) {
            return false;
        }
        return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
    }
}

