/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.Arrays;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.beliefsystem.abductive.Abductive;
import org.drools.core.rule.AbductiveQuery;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryImpl;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;

public class QueryBuilder
implements EngineElementBuilder {
    public Pattern build(RuleBuildContext context, QueryDescr queryDescr) {
        String returnName;
        Object[] types;
        String[] params;
        ClassObjectType queryObjectType = ClassObjectType.DroolsQuery_ObjectType;
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)queryObjectType, null);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, pattern, "name", null, true);
        QueryNameConstraint constraint = new QueryNameConstraint(extractor, queryDescr.getName());
        PatternBuilder.registerReadAccessor(context, (ObjectType)queryObjectType, "name", (AcceptsReadAccessor)constraint);
        pattern.addConstraint((Constraint)constraint);
        ClassObjectType argsObjectType = ClassObjectType.DroolsQuery_ObjectType;
        InternalReadAccessor arrayExtractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, null, (ObjectType)argsObjectType, "elements", null, true);
        QueryImpl query = (QueryImpl)context.getRule();
        int numParams = queryDescr.getParameters().length;
        if (query.isAbductive()) {
            params = Arrays.copyOf(queryDescr.getParameters(), queryDescr.getParameters().length + 1);
            types = Arrays.copyOf(queryDescr.getParameterTypes(), queryDescr.getParameterTypes().length + 1);
        } else {
            params = queryDescr.getParameters();
            types = queryDescr.getParameterTypes();
        }
        Declaration[] declarations = new Declaration[params.length];
        Class abductionReturnKlass = null;
        if (query.isAbductive()) {
            AnnotationDescr ann = queryDescr.getAnnotation(Abductive.class);
            returnName = ann.getValueAsString("target");
            try {
                abductionReturnKlass = context.getPkg().getTypeResolver().resolveType(returnName.replace(".class", ""));
                params[numParams] = "";
                types[numParams] = abductionReturnKlass.getName();
            }
            catch (ClassNotFoundException e) {
                context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve abducible type : " + returnName));
            }
        }
        int i = 0;
        try {
            for (i = 0; i < params.length; ++i) {
                Declaration declr = pattern.addDeclaration(params[i]);
                ArrayElementReader reader = new ArrayElementReader(arrayExtractor, i, context.getDialect().getTypeResolver().resolveType(types[i]));
                PatternBuilder.registerReadAccessor(context, (ObjectType)argsObjectType, "elements", (AcceptsReadAccessor)reader);
                declr.setReadAccessor((InternalReadAccessor)reader);
                declarations[i] = declr;
            }
            query.setParameters(declarations);
        }
        catch (ClassNotFoundException e) {
            context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve type '" + types[i] + " for parameter" + params[i]));
        }
        context.setPrefixPattern(pattern);
        if (query.isAbductive()) {
            returnName = "";
            try {
                AnnotationDescr ann = queryDescr.getAnnotation(Abductive.class);
                Object[] argsVal = (Object[])ann.getValue("args");
                String[] args = argsVal != null ? (String[])Arrays.copyOf(argsVal, argsVal.length, String[].class) : null;
                returnName = types[numParams];
                ClassObjectType objectType = new ClassObjectType(abductionReturnKlass, false);
                objectType = context.getPkg().getClassFieldAccessorStore().getClassObjectType(objectType, (AcceptsClassObjectType)((AbductiveQuery)query));
                ((AbductiveQuery)query).setReturnType(objectType, params, args, declarations);
            }
            catch (NoSuchMethodException e) {
                context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve abducible constructor for type : " + returnName + " with types " + Arrays.toString(types)));
            }
            catch (IllegalArgumentException e) {
                context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, e.getMessage()));
            }
        }
        return pattern;
    }
}

