% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_dune_d.R
\name{scale_color_dune_d}
\alias{scale_color_dune_d}
\title{Dune palettes for plotting with 'ggplot2'}
\usage{
scale_color_dune_d(name, ...)
}
\arguments{
\item{name}{Name of palette. Run \code{names(dune_palettes)} to view options}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
An object defining a discrete color scale for use with 'ggplot2'.
}
\description{
Dune palettes for plotting with 'ggplot2'
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, color = factor(cyl))) +
  geom_point() +
  scale_color_dune_d("harkonnen4")
}
