% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelTableModel.R
\name{RelTableModel}
\alias{RelTableModel}
\title{Create a RelTableModel object}
\usage{
RelTableModel(
  l = NULL,
  tableName,
  fields,
  primaryKey = NULL,
  foreignKeys = NULL,
  indexes = NULL,
  display = list(x = as.numeric(NA), y = as.numeric(NA), color = as.character(NA),
    comment = as.character(NA))
)
}
\arguments{
\item{l}{DEPRECATED. A named list with the function parameters.
If \code{NULL} (default) the function parameters are used. If not \code{NULL}, the
function parameters are ignored and taken from l.}

\item{tableName}{a character vector of length one}

\item{fields}{a tibble with the following columns:
\itemize{
\item \emph{name}: character
\item \emph{type}: character
\item \emph{nullable}: logical (optional, defaults to TRUE)
\item \emph{unique}: logical (optional, defaults = FALSE)
\item \emph{comment}:  character (optional, defaults to NA_character_)
}}

\item{primaryKey}{a character vector of any length. All
values should be in fields$name}

\item{foreignKeys}{a list of foreign keys. Each foreign key is defined
as a list with the following elements:
\itemize{
\item \emph{refTable}: a character vector of length one (the referenced table)
\item \emph{key}: a tibble with a "from" and a "to" columns
\item (\emph{cardinality}): an optional integer vector with 4 values:
\itemize{
\item fmin: from minimum cardinality
\item fmax: from maximum cardinality
\item tmin: to minimum cardinality
\item tmax: to maximum cardinality
}
}}

\item{indexes}{a list of indexes. Each index is defined by
3 columns:
\itemize{
\item \emph{field}: character (all in fields$name)
\item \emph{order}: character
\item \emph{unique}: logical
}}

\item{display}{a list gathering:
\itemize{
\item \emph{x}: single numeric value for the x position of the table
\item \emph{y}: single numeric value for the y position of the table
\item \emph{color}: single character value corresponding to the color of the table
\item \emph{comment}: single character value with some description of the table
}}
}
\value{
A RelTableModel object.
}
\description{
Create a RelTableModel object
}
\details{
When defining a matrix, 3 and only 3 fields must be defined:
2 of types 'row' and 'column' and the 3rd of your choice. In this case
primaryKey is defined automatically as the combination of row and column.
}
