% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_lr.test.R
\name{L_lr.test}
\alias{L_lr.test}
\title{Asymptotic  likelihood ratio test on record times}
\usage{
L_lr.test(XM_T, record = "upper")
}
\arguments{
\item{XM_T}{A numeric matrix.}

\item{record}{A character string indicating the type of record, "upper" or "lower".}
}
\value{
A list of class \code{"htest"}  with the following elements:
\item{statistic}{Value of the  statistic.}
\item{parameter}{Degrees of freedom of the approximate \eqn{\chi^2}distribution.}
\item{p.value}{P-value.}
\item{method}{A character string indicating the type of test.}
\item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs an asymptotic likelihood ratio test  based on the record times \eqn{L_i} to study the hypothesis of the classical record model.
}
\details{
The null  hypothesis  of this likelihood ratio test is that  in all the series, \eqn{m=1, ...M}, the probability of record at time \eqn{t} is \eqn{1/t}, and the alternative that the probability
at time \eqn{t} is any value, but equal in the \eqn{M} series.   The alternative hypothesis
 is more specific than the one  in \code{\link{L_MC.test}}.


Under the null, the likelihood ratio statistic has an asymptotic \eqn{\chi^2} distribution with \eqn{T-1}
degrees of  freedom.
}
\examples{
L_lr.test(ZaragozaSeries)
}
\seealso{
\code{\link{L.rec}}, \code{\link{L.plot}},  \code{\link{L_MC.test}}
}
