% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_joint.plot.R
\name{N_joint.plot}
\alias{N_joint.plot}
\title{Plot of the  difference (or ratio) between the number of upper and lower records}
\usage{
N_joint.plot(
  XM_T,
  type = "ratio",
  interval = "ribbon",
  conf = 0.95,
  samples = 1000,
  colour = "salmon"
)
}
\arguments{
\item{XM_T}{A  matrix.}

\item{type}{A character string indicating the type of statistic to be plotted, "ratio" or "difference".}

\item{interval}{A character string indicating the type of display of the confidence intervals,  \code{"ribbon"} (grey area) or \code{"errorbar"} (vertical lines).}

\item{conf}{Numeriv value in \eqn{(0,1)}. Confidence level of the confidence intervals.}

\item{samples}{An integer  giving the number of replicates used  to calculate Monte Carlo  confidence intervals.}

\item{colour}{Colour used to plot the expected values  and the CI. See  \code{\link{ggplot}} for valid values.}
}
\value{
A ggplot graph object.
}
\description{
This function constructs a ggplot object  to display the difference (or ratio) between the mean number of  upper records and
the mean number of lower records.
The expected values and  confidence intervals  of   \eqn{E(N_t)-E(N_t^{low})} (or  \eqn{E(N_t)/E(N_t^{low})}),
   under the hypothesis of the classical record model, are also plotted.
}
\details{
First, this function  calculates    the difference (or ratio) between the mean number of  upper records and
the  mean number of lower records up to time t, that is  \eqn{\bar N_t- \bar N_t^{low}} (or \eqn{\bar N_t/ \bar N_t^{low}}),
 The sample means  \eqn{\bar N_t} and \eqn{\bar N_t^{low}} are calculated from the sample of values  \eqn{ N_t} and \eqn{N_t^{low}},
  obtained from \eqn{M} vectors (columns of matrix \code{XM_T}). Then, these values are plotted and  compared with the functions of the expected values
\eqn{E(N_t)-E(N_t^{low})} (or \eqn{E(N_t)/E(N_t^{low})})   and their  confidence intervals  under the hypothesis of the classical record model,which are
 obtained using a bootstrap approach.
}
\examples{
N_joint.plot(ZaragozaSeries, samples=200)
}
\seealso{
\code{\link{N_joint.test}}, \code{\link{N.plot}}, \code{\link{N_normal.test}}
}
