% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value.rec.R
\name{value.rec}
\alias{value.rec}
\title{Record values}
\usage{
value.rec(X_T, record = "upper", variables = NULL)
}
\arguments{
\item{X_T}{A numeric vector.}

\item{record}{A character string indicating the type of record  be calculated, "upper" or "lower".}

\item{variables}{Optional. A matrix, containing other variables related to  \code{X_T} and measured at the same times.}
}
\value{
A data frame where the first column are the record times,  the second  the record values and, if \code{variables} is not null,
the third column   are their  values  at the record times.
}
\description{
This function identifies  the record values  (\eqn{R_i}), and the record times (\eqn{L_i}),  in a vector.
}
\examples{
 Y1<-c(5,7,3,6,19,2,20)
value.rec(Y1)
value.rec(TX_Zaragoza$TX,  variable= TX_Zaragoza$DATE)
}
