% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.point.R
\name{change.point}
\alias{change.point}
\title{Change-point Detection Tests Based on Records}
\usage{
change.point(
  X,
  weights = function(t) 1,
  record = c("upper", "lower", "d", "s"),
  correct = c("none", "fisher", "vrbik"),
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series. Castillo-Mateo (2021)
showed that the weights that get more power for this test are 
\eqn{\omega_t = \sqrt{t^2 / (t-1)}}, i.e., 
\code{weights = function(t) ifelse(t == 1, 0, sqrt(t^2 / (t-1)))} if
\code{record = "upper"} or \code{= "lower"}.
\eqn{\omega_t = \sqrt{t}}, i.e., \code{weights = function(t) sqrt(t)} if
\code{record = "d"} and \eqn{\omega_t = \sqrt{t^2 / (t-2)}}, i.e., 
\code{weights = function(t) ifelse(t \%in\% 1:2, 0, sqrt(t^2 / (t-2)))} if
\code{record = "s"}.}

\item{record}{A character string that indicates the type of statistic used.
If \code{record = "upper"} or \code{= "lower"}, the \eqn{I_{tm}}'s are the
upper or lower record indicators, respectively. If \code{record = "d"} or 
\code{= "s"}, \eqn{I_{tm}} is substituted in the expressions above by 
\eqn{I_{tm}^{(FU)} - I_{tm}^{(FL)}} or 
\eqn{I_{tm}^{(FU)} + I_{tm}^{(FL)}}, respectively.}

\item{correct}{A character string that indicates the continuity correction
in the Kolmogorov distribution made to the statistic. "fisher" (Fisher and
Robbins 2019), "vrbik" for the proposal by Vrbik (2020) or "none" (the 
default) if no correction is made. The former shows better 
size and power, but if the value of the statistic is too large it becomes 
\code{NaN} and p-value \code{NA}.}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation.}

\item{B}{If \code{simulate.p.value = TRUE}, an integer specifying the 
number of replicates used in the Monte Carlo estimation.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{p.value}{P-value.}
  \item{alternative}{The alternative hypothesis.}
  \item{estimate}{The estimated change-point time.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs change-point detection tests based on the record
  occurrence. The hypothesis of the classical record model (i.e., of IID 
  continuous RVs) is tested against the alternative hypothesis that after a 
  certain time the series stops being stationary.
}
\details{
The test is implemented as given by Castillo-Mateo (2021). The null 
  hypothesis is that 
  \deqn{H_0: p_t = 1/t, \qquad t=1,\ldots,T,}
  where \eqn{p_t} is the probability of (upper and/or lower) record at time 
  \eqn{t} and \eqn{T} is the length of the series, which corresponds to the 
  setup where the data come from a population with continuous independent 
  and identically distributed realisations. The two-sided alternative 
  hypothesis is that 
  \deqn{H_1: p_t = 1/t, \quad t=1,\ldots,t_0, \qquad p_t \neq 1/t, \quad t=t_0+1,\ldots,T,}
  for a change-point \eqn{t_0}.
  
  The variables used for the statistic are
  \deqn{
  \xi_{Tt} = \omega_t \frac{\left( \frac{1}{M}\sum_{m=1}^{M}  I_{tm} -  E(I_{tm})\right)}{\sigma_T},
  }
  where \eqn{\sigma_t^2 = \sum_{k=1}^{t} \omega_k^2 Var(I_k) / M} and
  \eqn{\omega_t} are weights given to the different records according
  to their position in the \eqn{m}th series of length \eqn{T}. If 
  \code{record = "upper"} or \code{= "lower"},
  the \eqn{I_{tm}}'s are the upper or lower record indicators, respectively
  (see \code{\link{I.record}}). If \code{record = "d"} or \code{= "s"},
  \eqn{I_{tm}} is substituted in the expressions above by 
  \eqn{I_{tm}^{(FU)} - I_{tm}^{(FL)}} or 
  \eqn{I_{tm}^{(FU)} + I_{tm}^{(FL)}}, respectively. Let 
  \eqn{S_{Tt} = \sum_{k=1}^{t} \xi_{Tk}}, 
  \eqn{s_{Tt} = \sum_{k=1}^{t} Var(\xi_{Tk})} and define the statistic
  \deqn{
  W_T(s) = S_{Tt} + \xi_{T,t+1} \frac{s - s_{Tt}}{s_{T,t+1} - s_{Tt}},
  }
  where \eqn{s \in [s_{Tt}, s_{T,t+1}]}.
  
  The test statistic is the maximum of the absolute value of the vector
  \deqn{
  K_T = \max_{1\le t \le T} |B_T(s_{Tt})|,
  }
  where \eqn{B_T(s) = W_T(s) - s W_T(1)}, \eqn{s \in [0,1]}.
  
  The probable change-point \eqn{\hat{t}_0} is located where \eqn{|B_T(s_{Tt})|} has its 
  maximum. The p-value is calculated by means of the asymptotic Kolmogorov
  distribution. When \eqn{\omega_t \neq 1}, the asymptotic result is not 
  fulfilled. In that case, the p-value can be simulated using Monte Carlo 
  techniques with the option \code{simulate.p.value = TRUE}.
  
  As this is an asymptotic result, it has been seen that the size and power
  may be a little below than expected, to correct this, any of the 
  continuity corrections can be used:
  
  If \code{correct = "fisher"},
  \deqn{K_T = - \sqrt{T} \log\left(1 - \frac{K_T}{\sqrt{T}}\right).}
  
  If \code{correct = "vrbik"},
  \deqn{K_T = K_T + \frac{1}{6\sqrt{T}} + \frac{K_T - 1}{4T}.}
}
\examples{
change.point(ZaragozaSeries)

change.point(ZaragozaSeries, record = "d", 
  weights = function(t) sqrt(t), simulate.p.value = TRUE)

test.result <- change.point(rowMeans(ZaragozaSeries))
test.result

## Not run: Load package ggplot2 to plot the changepoint
#library("ggplot2")
#records(rowMeans(ZaragozaSeries)) + 
#  ggplot2::geom_vline(xintercept = test.result$estimate, colour = "red")

}
\references{
Castillo-Mateo J (2021).
“Distribution-Free Changepoint Detection Tests Based on the Breaking of Records.”
Available at \href{https://arxiv.org/abs/2105.08186}{arXiv:2105.08186}

Fisher TJ, Robbins MW (2019). 
“A Cheap Trick to Improve the Power of a Conservative Hypothesis Test.”
\emph{The American Statistician}, \strong{73}(3), 232-242.
\doi{10.1080/00031305.2017.1395364}

Vrbik J (2020). 
“Deriving CDF of Kolmogorov-Smirnov Test Statistic.”
\emph{Applied Mathematics}, \strong{11}(3), 227-246.
\doi{10.4236/am.2020.113018}
}
\seealso{
\code{\link{records}}, \code{\link{foster.test}}
}
\author{
Jorge Castillo-Mateo
}
