% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcrm.R
\name{rcrm}
\alias{rcrm}
\title{The Classical Record Model}
\usage{
rcrm(Trows = 50, Mcols = 100, rdist = stats::rnorm, ...)
}
\arguments{
\item{Trows, Mcols}{Integers indicating the number of rows and columns of the
returned matrix, i.e., the length and number of series for the record 
analysis.}

\item{rdist}{A function that simulates continuous random variables, 
e.g., \code{\link{runif}} (fastest in \code{stats} package), 
\code{\link{rnorm}} or \code{\link{rexp}}.}

\item{...}{Further arguments to introduce in the \code{rdist} function.}
}
\value{
A matrix of draws of IID continuous RVs with common distribution 
  \code{rdist}.
}
\description{
Random generation for the classical record model, i.e.,
  sequences of independent and identically distributed (IID) continuous
  random variables (RVs).
}
\examples{
# By default, draw a sample of 100 series of length 50 
# with observations coming from a standard normal distribution 
X <- rcrm()
# Compute its record indicators
I <- I.record(X)
# Implement some tests
N.test(X, distribution = "poisson-binomial")
foster.test(X, weights = function(t) t-1, statistic = "D")

}
\references{
Arnold BC, Balakrishnan N, Nagaraja HN (1998). 
\emph{Records}. 
Wiley Series in Probability and Statistics. Wiley, New York.
}
\seealso{
\code{\link{L.record}}, \code{\link{S.record}}, 
  \code{\link{N.record}}, \code{\link{Nmean.record}}, 
  \code{\link{p.record}}, \code{\link{records}}
}
\author{
Jorge Castillo-Mateo
}
