\name{genv}
\alias{genv}
\title{Fit the groupwise envelope model}
\description{
 Fit the groupwise envelope model in multivariate linear regression with dimension u. 
}
\usage{
genv(X, Y, Z, u, asy = TRUE, fit = TRUE, init = NULL)
}

\arguments{
  \item{X}{
  Predictors. An n by p matrix, p is the number of predictors. The predictors can be univariate or multivariate, discrete or continuous.
  }
  \item{Y}{
  Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.
  }
  \item{Z}{
  A group indicator vector of length \eqn{n}, where \eqn{n} 
  denotes the number of observations.
  }
  \item{u}{
  Dimension of the groupwise envelope. An integer between 0 and r.
  }
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{fit}{Flag for computing the fitted response.  The default is \code{TRUE}.}
  \item{init}{The user-specified value of Gamma for the groupwise envelope subspace. An r by u matrix. The default is the one generated by function genvMU.}
}
\details{
 This function fits the groupwise envelope model to the responses and predictors, \deqn{
 Y_{(l)j} = \mu_{(l)} + \Gamma\eta_{(l)j} X_{(l)j}+\varepsilon_{(l)j}, \Sigma_{(l)}=\Gamma\Omega_{(l)}\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}
 }
 for l = 1, ..., L, using the maximum likelihood estimation.  When the dimension of the groupwise envelope is between 1 and r-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is r, then the envelope model degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different. When L is 1, the groupwise envelope model degenerates to the envelope model in Cook et al. (2010).
}

\value{The output is a list that contains the following components:
  \item{beta}{
  A list of \eqn{r} by \eqn{p} matrices for the estimator of
  regression coefficients.  \code{beta}[[i]] indicates the 
  estimator of regression coefficient for the ith group.
  }	
  \item{Sigma}{
  A list of the estimator of error covariance matrix. \code{Sigma}[[i]] contains the estimated covariance matrix for the ith group.
  }	
  \item{Gamma}{
  An orthonormal basis of the groupwise envelope subspace.
  }
  \item{Gamma0}{
  An orthonormal basis of the complement of the groupwise envelope subspace.
  }
  \item{eta}{
  The coordinates of beta with respect to Gamma.
  }
  \item{Omega}{
  The coordinates of Sigma with respect to Gamma.
  }
  \item{Omega0}{
  The coordinates of Sigma with respect to Gamma0.
  }
  \item{mu}{
  The estimator of group mean.  A \eqn{r} by \eqn{L} matrix  
  whose ith column contains the mean for the group.
  }
  \item{loglik}{
  The maximized log likelihood function.
  }
  \item{covMatrix}{
  A list of the asymptotic covariance of vec(beta). The covariance 
  matrix returned are asymptotic.  For the actual standard errors, 
  multiply by 1 / n. \code{covMatrix}[[i]] contains the asymptotic 
  covariance matrix for the ith group.
  }
  \item{asySE}{
  A list of the asymptotic standard error for elements in beta under 
  the groupwise envelope model.  The standard errors returned are 
  asymptotic, for actual standard errors, multiply by 1 / sqrt(n). 
  \code{asySE}[[i]] contains the asymptotic standard error for 
  elements in beta[[i]].
  }
  \item{ratio}{
  A list of the asymptotic standard error ratio of the standard 
  multivariate linear regression estimator over the groupwise envelope 
  estimator, for each element in beta. \code{ratio}[[i]] contains the 
  asymptotic standard error ratio for the ith group.
  }
  \item{groupInd}{
  A matrix containing the unique values of group indicators. The 
  matrix has p rows.	
  }
  \item{n}{
  The number of observations in the data.
  }
  \item{ng}{
  The number of observations in each group.
  }
  \item{Yfit}{
  Fitted responses.
  }
}

\references{
  Park, Y., Su, Z. and Zhu, H. (2017)  Groupwise envelope models for Imaging Genetic Analysis. Biometrics, to appear.
  
  Cook, R. D., Li, B. and Chiaromente, F. (2010). Envelope Models for Parsimonious and Efficient Multivariate Linear Regression (with discussion). Statist. Sinica 20, 927- 1010.
  
  Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(fiberpaper)
X <- fiberpaper[ , c(5, 7)]
Y <- fiberpaper[ , 1:3]
Z <- as.numeric(fiberpaper[ , 6] > mean(fiberpaper[ , 6]))
\dontrun{u <- u.genv(X, Y, Z)}
\dontrun{u}
\dontrun{m <- genv(X, Y, Z, 2)}

}
