\name{eppls}
\alias{eppls}

\title{
Fit the Envelope-based Partial Partial Least Squares model 
}

\description{
Fit the Envelope-based Partial Partial Least Squares model for multivariate linear regression with dimension u.
}

\usage{
eppls(X1, X2, Y, u, asy = TRUE, init = NULL)
}

\arguments{
  \item{X1}{
An \eqn{n} by \eqn{p1} matrix of continuous predictors, where \eqn{p1} is the  number of continuous predictors with \eqn{p1 < n}.
}
  \item{X2}{
An \eqn{n} by \eqn{p2} matrix of categorical predictors, where \eqn{p2} is the  number of categorical predictors with \eqn{p2 < n}.
}
  \item{Y}{
An \eqn{n} by \eqn{r} matrix of multivariate responses, where \eqn{r} is the number of responses.
}
  \item{u}{
A given dimension of the Envelope-based Partial Partial Least Squares.  It should be an interger between \eqn{0} and \eqn{p1}.
}

  \item{asy}{
Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.
  }
  
  \item{init}{
  The user-specified value of Gamma for the envelope subspace. An \eqn{r} by \eqn{u} matrix. The default is the one generated by function envMU.}

}

\details{
 This function the Envelope-based Partial Partial Least Squares model for multivariate linear regression with dimension \eqn{u}, \deqn{
 Y = \mu + \Gamma\eta X + \varepsilon, \Sigma=\Gamma\Omega\Gamma' + \Gamma_{0}\Omega_{0}\Gamma'_{0}
 }
 using the maximum likelihood estimation.  When the dimension of the envelope is between 1 and \eqn{p1}-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is \eqn{p1}, then the envelope model degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}

\value{The output is a list that contains the following components:
  \item{muY}{
The estimator of mean of \code{Y}. 
  }
    \item{mu1}{
The estimator of mean of \code{X1}. 
  }
    \item{mu2}{
The estimator of mean of \code{X2}. 
  }
  \item{beta1}{
A \eqn{p1} by \eqn{r} matrix for the estimator of regression coefficients for continuous predictors.
  }
    \item{beta2}{
A \eqn{p2} by \eqn{r} matrix for the estimator of regression coefficients for categorical predictors.
  }
  \item{Gamma}{
  An \eqn{p1} by \eqn{d} matrix for the orthogonal basis of the Envelope-based Partial Partial Least Squares.
  }
  \item{Gamma0}{
  An \eqn{p1} by \eqn{(p1-d)} matrix for the orthogonal basis of the complement of the Envelope-based Partial Partial Least Squares.
  }
    \item{gamma}{
  A \eqn{p2} by \eqn{p1} matrix for the estimator of regression coefficients based on the regression of \code{X1} on \code{X2}.
  }
  \item{eta}{
A \eqn{d} by \eqn{p1} matrix for the coordinates of \code{beta1} with respect to \code{Gamma}.
  }
  \item{Omega}{
A \eqn{d} by \eqn{d} matrix for the coordinates of \code{SigmaX1} with respect to \code{Gamma}.
  }
  \item{Omega0}{
A \eqn{(p1-d)} by \eqn{(p1-d)} matrix for the coordinates of \code{SigmaX1} with respect to \code{Gamma0}.
  }
  \item{SigmaX1}{
The estimator of error covariance matrix \code{Sigma}[1|2]. 
  }
  \item{SigmaYcX}{
The estimator of error covariance matrix \code{Sigma}[\code{Y}|\code{X}]. 
  }
  \item{loglik}{
  The maximized log likelihood function.
  }
  \item{n}{
  The number of observations in the data.
  }
  \item{covMatrix1}{
  The asymptotic covariance of vec(beta1). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.
  }
  \item{covMatrix2}{
  The asymptotic covariance of vec(beta2). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.
  }
  \item{asySE1}{
The asymptotic standard error matrix for elements in \code{beta1}. The multiplication by the reciprocal of square root of \eqn{n} returns actual standard errors.
  }
    \item{asySE2}{
The asymptotic standard error matrix for elements in \code{beta2}. The multiplication by the reciprocal of square root of \eqn{n} returns actual standard errors.
  }
}

\references{
Park, Y., Su, Z. and Chung, D. (2022+)  Envelope-based Partial Partial Least Squares with Application to Cytokine-based Biomarker Analysis for COVID-19.
}

\examples{
  data(amitriptyline)
  
  Y <- amitriptyline[ , 1:2]
  X1 <- amitriptyline[ , 4:7]
  X2 <- amitriptyline[ , 3]
  u <- u.eppls(X1, X2, Y)
  
  u
  
  m <- eppls(X1, X2, Y, 2)
  m
}
