% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGenome.R
\name{plotGenome}
\alias{plotGenome}
\title{plotGenome: plot replication profile.}
\usage{
plotGenome(ratioDFs, geom = "geom_point", ylims = c(1, 2),
  plotting = TRUE, genome = NULL, region = FALSE, guide = NULL,
  lines = NULL, circles = NULL, rectangles = NULL, pointers = NULL,
  colourLines = "#00FF00", colourCircles = "#FFFFFF",
  colourRectangles = "#FF0000", colourPointers = "#FF7F00")
}
\arguments{
\item{ratioDFs}{A ratio dataframe or combined ratios dataframe containing 'ratio' column (dataframe).}

\item{geom}{ggplot2 geom to use for plotting: "geom_point","geom_ribbon" or "geom_segment" (string, defaults to "geom_point").}

\item{ylims}{A vector of two values for y axis limits - first is lowest, second is highest (numeric vector, defaults to 1 and 2)}

\item{plotting}{Should the plot object be sent to the default device? (boolean, defaults to TRUE).}

\item{genome}{A mask dataframe to exclude data from the ratio dataframe (dataframe, optional).
The genome dataframe must contain "chrom","chromStart" and "chromEnd" columns.}

\item{region}{Only plot for the provided region in the format 'chrI:1000-3000' (string, optional).}

\item{guide}{A dataframe guiding the plotGenome function how to plot the data (dataframe, optional).
The guide dataframe must contain the following columns:
  'order' (integer) - order to plot data in,
  'name.rep' (character) - replicating sample name that matches the one in the ratioDFs dataframe,
  'name.nonRep' (character) - non-replicating sample name that matches the one in the ratioDFs dataframe,
  'raw' (logical) - should the raw raw data be plotted?
  'smooth' (logical) - should the smoothed data be plotted?
  'color'(character) - R color to plot the current sample with, both raw and smoothed data.}

\item{lines}{Additionally plot vertical lines from a BED formatted dataframe (dataframe, optional).}

\item{circles}{Additionally plot circles on the chromosome line from a BED formatted dataframe (dataframe, optional).}

\item{rectangles}{Additionally plot rectangles on the chromosome line from a BED formatted dataframe (dataframe, optional).}

\item{pointers}{Additionally plot downward pointing triangles from a BED formatted dataframe (dataframe, optional).}

\item{colourLines}{Colour for 'lines' data (string, defaults to green).}

\item{colourCircles}{Colour for 'circles' data (string, defaults to white).}

\item{colourRectangles}{Colour for 'rectangles' data (string, defaults to red).}

\item{colourPointers}{Colour for 'pointers' data (string, defaults to orange).}
}
\description{
plotGenome plots scatterplot/barplot/polygon of 'score' and/or 'splineSmooth' columns values
by genomic coordinates, either for the whole genome or a region. It also allows annotation
with additional BED-formatted data. Ggplot2 package is used for plotting.
}
\examples{
plotGenome(sortSeq,geom="geom_ribbon",guide=guide,region="chrIX:250000-439885",
    lines=sacCer3[["cen"]],circles=sacCer3[["ori"]])
# plot data as polygon for the specified region of chromosome 9

plotGenome(syncSeq[["data"]],geom="geom_segment",guide=syncSeq[["guide"]],
    region="chrVII:0-1090944",genome=sacCer3[["genome"]],lines=sacCer3[["cen"]],
    circles=sacCer3[["ori"]],colourLines="black")

plotGenome(MFAseq,region='chr1:0-2848000')
# plot marker frequency analysis for H.volcanii isolate DS2
}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{ggplot2}
\keyword{replication}
