/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.html4r.tools.utils;

public class POT
implements HTML4R {
    private String parent_type;
    private LinkedHashMap<Integer, String> textList = new LinkedHashMap();
    private LinkedHashMap<Integer, LinkedHashMap<String, String>> formatList = new LinkedHashMap();
    private int index = -1;

    public POT(String parentType) {
        this.parent_type = parentType;
    }

    public void addPot(String value, int size, boolean bold, boolean italic, boolean underlined, String color, String fontfamily, String valign) throws IOException {
        ++this.index;
        LinkedHashMap<String, String> rpr = Format.getTextProperties(color, size, bold, italic, underlined, fontfamily, valign);
        this.textList.put(this.index, StringEscapeUtils.escapeHtml((String)value));
        this.formatList.put(this.index, rpr);
    }

    public void addText(String value) throws IOException {
        ++this.index;
        this.textList.put(this.index, StringEscapeUtils.escapeHtml((String)value));
        this.formatList.put(this.index, null);
    }

    @Override
    public String getHTML() {
        String out = "";
        out = this.parent_type.equals("div") ? String.valueOf(out) + "<p>" : (this.parent_type.equals("ul") ? String.valueOf(out) + "<li>" : (this.parent_type.equals("ol") ? String.valueOf(out) + "<li>" : (this.parent_type.equals("pre") ? String.valueOf(out) : String.valueOf(out) + "<p>")));
        int i = 0;
        while (i < this.index + 1) {
            out = this.formatList.get(i) == null ? String.valueOf(out) + utils.span(this.textList.get(i)) : String.valueOf(out) + utils.span_style(this.textList.get(i), Format.getJSString(this.formatList.get(i)));
            ++i;
        }
        out = this.parent_type.equals("div") ? String.valueOf(out) + "</p>" : (this.parent_type.equals("ul") ? String.valueOf(out) + "</li>" : (this.parent_type.equals("ol") ? String.valueOf(out) + "</li>" : (this.parent_type.equals("pre") ? String.valueOf(out) : String.valueOf(out) + "</p>")));
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

