/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.docx4j.dml.CTTableCell;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.tables.BorderProperties;
import org.lysis.reporters.tables.CellProperties;
import org.lysis.reporters.texts.ParagraphsSection;

public class FlexCell
implements HTML4R,
Cloneable {
    private ParagraphsSection section;
    private CellProperties cellProproperties;
    private int colspan;
    private int rowspan;

    public FlexCell(ParagraphsSection p, CellProperties cp) {
        this.setParagraphsSection(p);
        this.setCellProperties(cp);
        this.colspan = 1;
        this.rowspan = 1;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int value) {
        this.colspan = value;
    }

    public void setParagraphsSection(ParagraphsSection p) {
        this.section = p;
    }

    public void setCellProperties(CellProperties cp) {
        this.cellProproperties = cp;
    }

    public void setBorderBottom(BorderProperties bp) {
        this.cellProproperties.setBorderBottom(bp);
    }

    public void setBorderTop(BorderProperties bp) {
        this.cellProproperties.setBorderTop(bp);
    }

    public void setBorderLeft(BorderProperties bp) {
        this.cellProproperties.setBorderLeft(bp);
    }

    public void setBorderRight(BorderProperties bp) {
        this.cellProproperties.setBorderRight(bp);
    }

    public void setRowspan(int value) {
        this.rowspan = value;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + this.section.toString();
        return out;
    }

    @Override
    public String getHTML() {
        if (this.rowspan < 1) {
            return "";
        }
        if (this.colspan < 1) {
            return "";
        }
        LinkedHashMap<String, String> cpr = org.lysis.reporters.html4r.tools.Format.getCellProperties(this.cellProproperties.getBorderBottom().getBorderColor(), this.cellProproperties.getBorderBottom().getBorderStyle(), this.cellProproperties.getBorderBottom().getBorderWidth(), this.cellProproperties.getBorderLeft().getBorderColor(), this.cellProproperties.getBorderLeft().getBorderStyle(), this.cellProproperties.getBorderLeft().getBorderWidth(), this.cellProproperties.getBorderTop().getBorderColor(), this.cellProproperties.getBorderTop().getBorderStyle(), this.cellProproperties.getBorderTop().getBorderWidth(), this.cellProproperties.getBorderRight().getBorderColor(), this.cellProproperties.getBorderRight().getBorderStyle(), this.cellProproperties.getBorderRight().getBorderWidth(), this.cellProproperties.getVerticalAlign(), this.cellProproperties.getPaddingBottom(), this.cellProproperties.getPaddingTop(), this.cellProproperties.getPaddingLeft(), this.cellProproperties.getPaddingRight(), this.cellProproperties.getBackgroundColor());
        String out = "<td style=\"" + org.lysis.reporters.html4r.tools.Format.getJSString(cpr) + "\"";
        if (this.colspan > 1) {
            out = String.valueOf(out) + " colspan=\"" + this.colspan + "\"";
        }
        if (this.rowspan > 1) {
            out = String.valueOf(out) + " rowspan=\"" + this.rowspan + "\"";
        }
        out = String.valueOf(out) + ">";
        out = String.valueOf(out) + this.section.getHTML();
        out = String.valueOf(out) + "</td>";
        return out;
    }

    public Tc getTc() {
        TcPrInner.VMerge merge;
        Tc tc = new Tc();
        tc.getContent().addAll(this.section.getP());
        TcPr tcPr = org.lysis.reporters.docx4r.tools.Format.getCellProperties(this.cellProproperties.getBorderBottom().getBorderColor(), this.cellProproperties.getBorderBottom().getBorderStyle(), this.cellProproperties.getBorderBottom().getBorderWidth(), this.cellProproperties.getBorderLeft().getBorderColor(), this.cellProproperties.getBorderLeft().getBorderStyle(), this.cellProproperties.getBorderLeft().getBorderWidth(), this.cellProproperties.getBorderTop().getBorderColor(), this.cellProproperties.getBorderTop().getBorderStyle(), this.cellProproperties.getBorderTop().getBorderWidth(), this.cellProproperties.getBorderRight().getBorderColor(), this.cellProproperties.getBorderRight().getBorderStyle(), this.cellProproperties.getBorderRight().getBorderWidth(), this.cellProproperties.getVerticalAlign(), this.cellProproperties.getPaddingBottom(), this.cellProproperties.getPaddingTop(), this.cellProproperties.getPaddingLeft(), this.cellProproperties.getPaddingRight(), this.cellProproperties.getBackgroundColor());
        if (this.colspan > 1) {
            TcPrInner.GridSpan gridSpan = new TcPrInner.GridSpan();
            gridSpan.setVal(BigInteger.valueOf(this.colspan));
            tcPr.setGridSpan(gridSpan);
        }
        if (this.rowspan > 1) {
            merge = new TcPrInner.VMerge();
            merge.setVal("restart");
            tcPr.setVMerge(merge);
        } else if (this.rowspan < 1) {
            merge = new TcPrInner.VMerge();
            merge.setVal("continue");
            tcPr.setVMerge(merge);
        }
        tc.setTcPr(tcPr);
        return tc;
    }

    public CTTableCell getCTTableCell() throws Exception {
        CTTableCell tc = new CTTableCell();
        tc.setTxBody(this.section.getCTTextBody());
        CTTableCellProperties tcPr = Format.getCellProperties(this.cellProproperties.getBorderBottom().getBorderColor(), this.cellProproperties.getBorderBottom().getBorderStyle(), this.cellProproperties.getBorderBottom().getBorderWidth(), this.cellProproperties.getBorderLeft().getBorderColor(), this.cellProproperties.getBorderLeft().getBorderStyle(), this.cellProproperties.getBorderLeft().getBorderWidth(), this.cellProproperties.getBorderTop().getBorderColor(), this.cellProproperties.getBorderTop().getBorderStyle(), this.cellProproperties.getBorderTop().getBorderWidth(), this.cellProproperties.getBorderRight().getBorderColor(), this.cellProproperties.getBorderRight().getBorderStyle(), this.cellProproperties.getBorderRight().getBorderWidth(), this.cellProproperties.getVerticalAlign(), this.cellProproperties.getPaddingBottom(), this.cellProproperties.getPaddingTop(), this.cellProproperties.getPaddingLeft(), this.cellProproperties.getPaddingRight(), this.cellProproperties.getBackgroundColor());
        if (this.colspan > 1) {
            tc.setGridSpan(Integer.valueOf(this.colspan));
        } else if (this.colspan < 1) {
            tc = new CTTableCell();
            tc.setHMerge(Boolean.valueOf(true));
            CTTableCellProperties temp = new CTTableCellProperties();
            temp.setNoFill(tcPr.getNoFill());
            tc.setTcPr(temp);
            return tc;
        }
        if (this.rowspan > 1) {
            tc.setRowSpan(Integer.valueOf(this.rowspan));
        } else if (this.rowspan < 1) {
            tc.setVMerge(Boolean.valueOf(true));
        }
        if (this.colspan > 0) {
            tc.setTcPr(tcPr);
        }
        return tc;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    public FlexCell clone() {
        FlexCell fc = new FlexCell(this.section, this.cellProproperties);
        return fc;
    }
}

