/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.STTextUnderlineType;
import org.docx4j.dml.TextFont;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTVerticalAlignRun;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STVerticalAlignRun;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import org.lysis.reporters.pptx4r.tools.Format;

public class TextProperties {
    private int size;
    private boolean bold;
    private boolean italic;
    private boolean underlined;
    private String color;
    private String fontfamily;
    private String valign;

    public int getSize() {
        return this.size;
    }

    public boolean isBold() {
        return this.bold;
    }

    public String getValign() {
        return this.valign;
    }

    public boolean isSub() {
        return this.valign.equals("subscript");
    }

    public boolean isSuper() {
        return this.valign.equals("superscript");
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public String getColor() {
        return this.color;
    }

    public String getFontfamily() {
        return this.fontfamily;
    }

    public TextProperties(int size, boolean bold, boolean italic, boolean underlined, String color, String fontfamily, String valign) {
        this.size = size;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.color = color;
        this.fontfamily = fontfamily;
        this.valign = valign;
    }

    public LinkedHashMap<String, String> get_html_pr() {
        LinkedHashMap<String, String> runProperties = new LinkedHashMap<String, String>();
        runProperties.put("font-size", String.valueOf(this.size) + "px");
        runProperties.put("font-family", this.fontfamily);
        if (this.bold) {
            runProperties.put("font-weight", "bold");
        }
        if (this.italic) {
            runProperties.put("font-style", "italic");
        }
        if (this.underlined) {
            runProperties.put("text-decoration", "underline");
        }
        runProperties.put("color", this.color);
        if (this.valign.equals("subscript")) {
            runProperties.put("vertical-align", "sub");
        } else if (this.valign.equals("superscript")) {
            runProperties.put("vertical-align", "super");
        }
        return runProperties;
    }

    public LinkedHashMap<String, String> get_html_pr_vanilla() {
        LinkedHashMap<String, String> runProperties = new LinkedHashMap<String, String>();
        if (this.bold) {
            runProperties.put("font-weight", "bold");
        }
        if (this.italic) {
            runProperties.put("font-style", "italic");
        }
        if (this.underlined) {
            runProperties.put("text-decoration", "underline");
        }
        runProperties.put("color", this.color);
        return runProperties;
    }

    public RPr get_docx_pr() {
        CTVerticalAlignRun vv;
        BooleanDefaultTrue b;
        RPr runProperties = new RPr();
        HpsMeasure fsize = new HpsMeasure();
        fsize.setVal(BigInteger.valueOf(this.size * 2));
        runProperties.setSz(fsize);
        RFonts rfonts = new RFonts();
        rfonts.setAscii(this.fontfamily);
        rfonts.setCs(this.fontfamily);
        rfonts.setHAnsi(this.fontfamily);
        runProperties.setRFonts(rfonts);
        if (this.bold) {
            b = new BooleanDefaultTrue();
            b.setVal(Boolean.valueOf(true));
            runProperties.setB(b);
        }
        if (this.italic) {
            b = new BooleanDefaultTrue();
            b.setVal(Boolean.valueOf(true));
            runProperties.setI(b);
        }
        if (this.underlined) {
            U u = new U();
            u.setVal(UnderlineEnumeration.SINGLE);
            runProperties.setU(u);
        }
        if (this.valign.equals("subscript")) {
            vv = new CTVerticalAlignRun();
            vv.setVal(STVerticalAlignRun.SUBSCRIPT);
            runProperties.setVertAlign(vv);
        } else if (this.valign.equals("superscript")) {
            vv = new CTVerticalAlignRun();
            vv.setVal(STVerticalAlignRun.SUPERSCRIPT);
            runProperties.setVertAlign(vv);
        }
        Color col = new Color();
        col.setVal(this.color);
        runProperties.setColor(col);
        return runProperties;
    }

    public CTTextCharacterProperties get_pptx_pr() throws Exception {
        CTTextCharacterProperties runProperties = new CTTextCharacterProperties();
        runProperties.setSz(Integer.valueOf(this.size * 100));
        TextFont tf = new TextFont();
        tf.setTypeface(this.fontfamily);
        runProperties.setCs(tf);
        runProperties.setLatin(tf);
        runProperties.setEa(tf);
        if (this.bold) {
            runProperties.setB(Boolean.valueOf(this.bold));
        }
        if (this.italic) {
            runProperties.setI(Boolean.valueOf(this.italic));
        }
        if (this.underlined) {
            runProperties.setU(STTextUnderlineType.SNG);
        }
        if (this.valign.equals("subscript")) {
            runProperties.setBaseline(Integer.valueOf(-25000));
        } else if (this.valign.equals("superscript")) {
            runProperties.setBaseline(Integer.valueOf(30000));
        }
        runProperties.setSolidFill(Format.getCol(this.color));
        return runProperties;
    }
}

