\name{textProperties}
\alias{textProperties}
\title{Text formatting properties}
\usage{
textProperties(color = "black", font.size = getOption("ReporteRs-fontsize"),
  font.weight = "normal", font.style = "normal", underlined = FALSE,
  font.family = getOption("ReporteRs-default-font"),
  vertical.align = "baseline")
}
\arguments{
  \item{color}{font color - a single character value
  specifying a valid color (e.g. "#000000" or "black").}

  \item{font.size}{font size - 0 or positive integer
  value.}

  \item{font.weight}{single character value specifying font
  weight (expected value is \code{normal} or \code{bold}).}

  \item{font.style}{single character value specifying font
  style (expected value is \code{normal} or
  \code{italic}).}

  \item{underlined}{single logical value specifying if the
  font is underlined.}

  \item{font.family}{single character value specifying font
  name (it has to be an existing font in the OS).}

  \item{vertical.align}{single character value specifying
  font vertical alignments. Expected value is one of the
  following : default \code{'baseline'} or
  \code{'subscript'} or \code{'superscript'}}
}
\value{
a \code{textProperties} object
}
\description{
Create a \code{textProperties} object that describes text
formatting properties.
}
\details{
Default values are: \itemize{ \item \code{color} "black"
\item \code{font.size} getOption("ReporteRs-fontsize")
\item \code{font.weight} "normal" \item \code{font.style}
"normal" \item \code{underlined} FALSE \item
\code{font.family} getOption("ReporteRs-default-font")
\item \code{vertical.align} "baseline" }
}
\examples{
\donttest{
parProperties( text.align = "center", padding = 5)
parProperties( text.align = "center", padding.top = 5
, padding.bottom = 0, padding.left = 2, padding.right = 0)
}
}
\seealso{
\code{\link{cellProperties}}, \code{\link{parProperties}} ,
\code{\link{chprop.parProperties}},
\code{\link{chprop.textProperties}} ,
\code{\link{chprop.cellProperties}} ,
\code{\link{FlexTable}}, \code{\link{tableProperties}},
\code{\link{addTable}} , \code{\link{pot}}
}

