/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.tables;

import java.util.LinkedHashMap;

import org.docx4j.dml.CTTableRow;
import org.docx4j.wml.Tr;
import org.lysis.reporters.tools.HTML4R;

public class FlexRow implements HTML4R{
	
	private LinkedHashMap<Integer, FlexCell> cellList;
	
	public FlexRow(){
		cellList = new LinkedHashMap<Integer, FlexCell>();
	}
	
	public void add(FlexCell fc){
		cellList.put(size(), fc);
	}
	public void add(FlexCell fc, int i){
		cellList.put(i, fc);
	}
	public int size(){
		return cellList.size() ;
	}
	public int weight(){
		int out = 0;
		if( size() > 0 )
			for(int i = 0 ; i < size()  ; i++ ){
				out += cellList.get(i).getColspan();
			}
		
		return out ;
	}
	public FlexCell getCell(int index){
		return cellList.get(index);
	}
	public boolean hasCell(int index){
		return cellList.containsKey(index);
	}
	
	public int getCellIDCellAt(int index){
		int cell_id = 0;
		int colspan_curr = 0;
		while( true ){
			if( hasCell( cell_id ) ){
				colspan_curr += getCell( cell_id ).getColspan();
			}
			if( colspan_curr > index ) break;
			cell_id++;
		}

		return cell_id;
	}
	public boolean hasCellAt(int index){
		int cell_id = 0;
		int colspan_curr = 0;
		while( true ){
			if( hasCell( cell_id ) ){
				colspan_curr += getCell( cell_id ).getColspan();
			}
			if( colspan_curr > index ) return true;
			if( !hasCell( cell_id + 1 ) ) return false;
			cell_id++;
		}
		
	}
	

	public String toString(){
		String out = "";
		if( size() > 0 )
			for(int i = 0 ; i < size()  ; i++ ){
				out += cellList.get(i).toString();
			}
		return out;
	}

	@Override
	public String getHTML() {
		
		
		String out = "<tr>";
		for( int i = 0 ; i < size() ; i++ ){
			out += cellList.get(i).getHTML();
		}
			
		out += "</tr>";
		
		return out;
	}

	public Tr getTr() throws Exception{
		Tr workingRow = new Tr();
		for( int i = 0 ; i < size() ; i++ ){
			workingRow.getContent().add(cellList.get(i).getTc());
		}
		return workingRow;
	}
	
	public CTTableRow getCTTableRow() throws Exception{
		CTTableRow workingRow = new CTTableRow();
		for( int i = 0 ; i < size() ; i++ ){
			FlexCell temp = cellList.get(i);
			workingRow.getTc().add(temp.getCTTableCell());
			if( temp.getColspan() > 1 ) {
				for(int p = 1 ; p < temp.getColspan() ; p++ ){
					FlexCell temp1 = temp.clone();
					temp1.setColspan(0);
					workingRow.getTc().add( temp1.getCTTableCell() );
				}
			}
			
		}
		return workingRow;
	}
	
	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}
	
}
