package org.lysis.reporters.lists;

import java.math.BigInteger;

import org.docx4j.wml.CTLongHexNumber;
import org.docx4j.wml.Numbering.AbstractNum;
import org.docx4j.wml.Numbering.AbstractNum.MultiLevelType;

public class DocxListNumberingDefinition {

	private int nsid;
	private int tmpl;
	private int id;
		
	public DocxListNumberingDefinition(int id) {
		this.id = id;
		nsid = id * 2 + 1;
		tmpl = id * 2 + 2;
	}
	
	public AbstractNum getDocxAbstractNum(){
		AbstractNum absNum = new AbstractNum(); 
		
		CTLongHexNumber nsidhex;
		nsidhex = new CTLongHexNumber();
		nsidhex.setVal(Integer.toHexString(nsid));

		CTLongHexNumber tmplhex;
		tmplhex = new CTLongHexNumber();
		tmplhex.setVal(Integer.toHexString(tmpl));

		absNum.setAbstractNumId( BigInteger.valueOf( id ) ); 

		absNum.setNsid(nsidhex); 
        absNum.setTmpl(tmplhex); 
		
        MultiLevelType numberingabstractnummultileveltype = new MultiLevelType(); 
        numberingabstractnummultileveltype.setVal( "hybridMultilevel");
        absNum.setMultiLevelType(numberingabstractnummultileveltype);	
        
        return absNum;
	}
	
}
