% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSubtitle.pptx.R
\name{addSubtitle.pptx}
\alias{addSubtitle.pptx}
\title{Insert a addSubtitle shape into a pptx object}
\usage{
\method{addSubtitle}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{\code{"character"} value to use as subtitle text}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add a addSubtitle shape into a \code{\link{pptx}} object.
}
\details{
Subtitle shape only exist in slide of type 'Title Slide'.
}
\examples{
doc.filename = "addSubtitle_example.pptx"

options( "ReporteRs-fontsize" = 24 )
doc = pptx( title = "title" )
doc = addSlide( doc, slide.layout = "Title Slide" )
#set the main title
doc = addTitle( doc, "Presentation title" ) 
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")

writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{pptx}}, \code{\link{addSubtitle}}
}

