/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.images;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.jaxb.Context;
import org.docx4j.model.images.AbstractWordXmlPicture;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.vml.CTImageData;
import org.docx4j.vml.CTShape;
import org.docx4j.wml.Pict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class WordXmlPictureE10
extends AbstractWordXmlPicture {
    protected static Logger log = LoggerFactory.getLogger(WordXmlPictureE10.class);
    Pict pict;
    CTShape shape = null;
    CTImageData imageData = null;

    private WordXmlPictureE10(WordprocessingMLPackage wmlPackage, Object wpict) {
        this.wmlPackage = wmlPackage;
        if (wpict != null) {
            Node n;
            if (wpict instanceof Pict) {
                this.pict = (Pict)wpict;
            } else if (wpict instanceof NodeIterator && (n = ((NodeIterator)wpict).nextNode()) != null) {
                Object jaxb = null;
                try {
                    jaxb = XmlUtils.unmarshal(n, Context.jc, Pict.class);
                }
                catch (JAXBException e1) {
                    e1.printStackTrace();
                }
                try {
                    this.pict = (Pict)jaxb;
                }
                catch (ClassCastException e) {
                    log.error("Couldn't cast " + jaxb.getClass().getName() + " to PPr!");
                }
            }
        }
    }

    private void findShape() {
        if (this.pict.getAnyAndAny() != null) {
            for (Object o : this.pict.getAnyAndAny()) {
                if (o instanceof JAXBElement) {
                    JAXBElement jb = (JAXBElement)o;
                    if (jb.getDeclaredType().getName().equals("org.docx4j.vml.CTShapetype")) continue;
                    if (jb.getDeclaredType().getName().equals("org.docx4j.vml.CTShape")) {
                        this.shape = (CTShape)jb.getValue();
                        break;
                    }
                    log.info("Skipping " + XmlUtils.JAXBElementDebug((JAXBElement)o));
                    continue;
                }
                log.error(o.getClass().getName());
            }
        }
    }

    private void findImageData() {
        if (this.shape.getPathOrFormulasOrHandles() == null) {
            log.debug("Shape had no any: " + XmlUtils.marshaltoString(this.shape, true));
        } else {
            for (JAXBElement<?> o : this.shape.getPathOrFormulasOrHandles()) {
                Object o2 = XmlUtils.unwrap(o);
                if (o2 instanceof CTImageData) {
                    this.imageData = (CTImageData)o2;
                    break;
                }
                log.error(o.getClass().getName());
            }
        }
    }

    private static WordXmlPictureE10 createWordXmlPictureFromE10(WordprocessingMLPackage wmlPackage, ConversionImageHandler imageHandler, Object wpict, Part sourcePart) {
        WordXmlPictureE10 converter = new WordXmlPictureE10(wmlPackage, wpict);
        converter.findShape();
        if (converter.shape == null) {
            log.error("Couldn't find shape!");
            return null;
        }
        converter.readStandardAttributes(converter.shape);
        converter.readDimensions(converter.style);
        converter.findImageData();
        if (converter.imageData == null) {
            log.error("Couldn't find imageData!");
            return null;
        }
        String imgRelId = converter.imageData.getId();
        if (imgRelId != null && !imgRelId.equals("")) {
            log.debug("Handling " + imgRelId);
            converter.handleImageRel(imageHandler, imgRelId, sourcePart);
        } else {
            log.error("No relId?!");
        }
        return converter;
    }

    public static DocumentFragment createHtmlImgE10(AbstractWmlConversionContext context, Object wpict) {
        return WordXmlPictureE10.createHtmlImgE10(context, wpict, null);
    }

    public static DocumentFragment createHtmlImgE10(AbstractWmlConversionContext context, Object wpict, String id) {
        Part sourcePart = context.getCurrentPart();
        WordXmlPictureE10 converter = WordXmlPictureE10.createWordXmlPictureFromE10(context.getWmlPackage(), context.getImageHandler(), wpict, sourcePart);
        if (id != null) {
            converter.setID(id);
        }
        return WordXmlPictureE10.getHtmlDocumentFragment(converter);
    }

    public static DocumentFragment createXslFoImgE10(AbstractWmlConversionContext context, NodeIterator wpict) {
        Part sourcePart = context.getCurrentPart();
        WordXmlPictureE10 converter = WordXmlPictureE10.createWordXmlPictureFromE10(context.getWmlPackage(), context.getImageHandler(), wpict, sourcePart);
        if (converter == null) {
            log.error("WordXmlPictureE10 object was null!");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                Document d = factory.newDocumentBuilder().newDocument();
                return d.createDocumentFragment();
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        Document d = converter.createXslFoImageElement();
        DocumentFragment docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    public static DocumentFragment createXslFoImgE10(AbstractWmlConversionContext context, Object wpict) {
        Part sourcePart = context.getCurrentPart();
        WordXmlPictureE10 converter = WordXmlPictureE10.createWordXmlPictureFromE10(context.getWmlPackage(), context.getImageHandler(), wpict, sourcePart);
        if (converter == null) {
            log.error("WordXmlPictureE10 object was null!");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                Document d = factory.newDocumentBuilder().newDocument();
                return d.createDocumentFragment();
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        Document d = converter.createXslFoImageElement();
        DocumentFragment docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    private void readStandardAttributes(CTShape shape) {
        this.id = shape.getVmlId();
        this.pType = shape.getType();
        this.alt = shape.getAlt();
        this.style = shape.getStyle();
    }

    private void readDimensions(String style) {
        if (style == null) {
            log.warn("can't read dimensions from null shape style");
            return;
        }
        this.dimensions = new AbstractWordXmlPicture.Dimensions();
        if (style.lastIndexOf("width") >= 0) {
            this.getStyleVal("width");
        }
        if (style.lastIndexOf("height") >= 0) {
            this.getStyleVal("height");
        }
    }

    private void getStyleVal(String name) {
        String unit;
        log.info("Looking for '" + name + "' in " + this.style);
        int beginIndex = this.style.indexOf(name) + name.length() + 1;
        if (beginIndex < 0) {
            log.debug("No value for '" + name);
            return;
        }
        int endIndex = this.style.indexOf(";", beginIndex);
        String val = endIndex < 0 ? this.style.substring(beginIndex) : this.style.substring(beginIndex, endIndex);
        log.debug("val: " + val);
        float f = 0.0f;
        if (val.endsWith("pt")) {
            f = Float.parseFloat(val.substring(0, val.length() - 2));
            unit = "pt";
            log.debug(f + "pt");
        } else if (val.endsWith("in")) {
            f = Float.parseFloat(val.substring(0, val.length() - 2));
            unit = "in";
            log.debug(f + "in");
        } else {
            unit = "??";
        }
        if (name.equals("height")) {
            this.dimensions.height = Math.round(f);
            this.dimensions.heightUnit = unit;
        } else if (name.equals("width")) {
            this.dimensions.width = Math.round(f);
            this.dimensions.widthUnit = unit;
        }
    }
}

