/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.Matrix;

public final class MatrixInt
implements Matrix {
    private int[][] matrix;

    public void setup(int width, int height) {
        this.matrix = new int[width][height];
    }

    public void set(int i, int j, int x) {
        this.matrix[i][j] = x;
    }

    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    public void incrementPathBy(int i, int j, int n) {
        this.matrix[i][j] = this.matrix[i + 1][j + 1] + n;
    }

    public void incrementByMaxPath(int i, int j) {
        this.matrix[i][j] = Math.max(this.matrix[i + 1][j], this.matrix[i][j + 1]);
    }

    public boolean isGreaterX(int i, int j) {
        return this.matrix[i + 1][j] > this.matrix[i][j + 1];
    }

    public boolean isGreaterY(int i, int j) {
        return this.matrix[i + 1][j] < this.matrix[i][j + 1];
    }

    public boolean isSameXY(int i, int j) {
        return this.matrix[i + 1][j] == this.matrix[i][j + 1];
    }

    public void release() {
        this.matrix = null;
    }
}

