/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkInterface;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.AltChunkFinder;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbXmlPartAltChunkHost<E>
extends JaxbXmlPartXPathAware<E>
implements AltChunkInterface {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPartAltChunkHost.class);

    public JaxbXmlPartAltChunkHost(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(bytes);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (!(this instanceof ContentAccessor)) {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        ((ContentAccessor)((Object)this)).getContent().add(ac);
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(is);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (!(this instanceof ContentAccessor)) {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        ((ContentAccessor)((Object)this)).getContent().add(ac);
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes, ContentAccessor attachmentPoint) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(bytes);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        attachmentPoint.getContent().add(ac);
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is, ContentAccessor attachmentPoint) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(is);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        attachmentPoint.getContent().add(ac);
        return afiPart;
    }

    @Override
    public WordprocessingMLPackage convertAltChunks() throws Docx4JException {
        if (!(this instanceof ContentAccessor)) {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        PartName partName = this.getPartName();
        WordprocessingMLPackage clonePkg = (WordprocessingMLPackage)this.getPackage().clone();
        JaxbXmlPartAltChunkHost clonedPart = (JaxbXmlPartAltChunkHost)clonePkg.getParts().get(partName);
        List<Object> contentList = ((ContentAccessor)((Object)clonedPart)).getContent();
        AltChunkFinder bf = new AltChunkFinder();
        new TraversalUtil(contentList, bf);
        boolean encounteredDocxAltChunk = false;
        for (AltChunkFinder.LocatedChunk locatedChunk : bf.getAltChunks()) {
            CTAltChunk altChunk = locatedChunk.getAltChunk();
            AlternativeFormatInputPart afip = (AlternativeFormatInputPart)clonedPart.getRelationshipsPart().getPart(altChunk.getId());
            AltChunkType type = afip.getAltChunkType();
            if (type.equals((Object)AltChunkType.Xhtml)) {
                XHTMLImporter xHTMLImporter = null;
                try {
                    Class<?> xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.XHTMLImporterImpl");
                    Constructor<?> ctor = xhtmlImporterClass.getConstructor(WordprocessingMLPackage.class);
                    xHTMLImporter = (XHTMLImporter)ctor.newInstance(clonePkg);
                }
                catch (Exception e) {
                    log.error("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                List<Object> results = null;
                try {
                    results = xHTMLImporter.convert(this.toString(afip.getBuffer()), null);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                int index = locatedChunk.getIndex();
                locatedChunk.getContentList().remove(index);
                locatedChunk.getContentList().addAll(index, results);
                log.info("Converted altChunk of type XHTML ");
                continue;
            }
            if (type.equals((Object)AltChunkType.Mht)) {
                log.warn("Skipping altChunk of type MHT ");
                continue;
            }
            if (type.equals((Object)AltChunkType.Xml)) {
                log.warn("Skipping altChunk of type XML ");
                continue;
            }
            if (type.equals((Object)AltChunkType.TextPlain)) {
                String result = null;
                try {
                    result = this.toString(afip.getBuffer());
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                if (result == null) continue;
                int index = locatedChunk.getIndex();
                locatedChunk.getContentList().remove(index);
                ObjectFactory factory = Context.getWmlObjectFactory();
                P para = factory.createP();
                locatedChunk.getContentList().add(index, para);
                R run = factory.createR();
                para.getContent().add(run);
                Text t = factory.createText();
                t.setValue(result);
                run.getContent().add(t);
                log.info("Converted altChunk of type text ");
                continue;
            }
            if (type.equals((Object)AltChunkType.WordprocessingML) || type.equals((Object)AltChunkType.OfficeWordMacroEnabled) || type.equals((Object)AltChunkType.OfficeWordTemplate) || type.equals((Object)AltChunkType.OfficeWordMacroEnabledTemplate)) {
                encounteredDocxAltChunk = true;
                continue;
            }
            if (type.equals((Object)AltChunkType.Rtf)) {
                log.warn("Skipping altChunk of type RTF ");
                continue;
            }
            if (!type.equals((Object)AltChunkType.Html)) continue;
            log.warn("Skipping altChunk of type HTML ");
        }
        if (encounteredDocxAltChunk) {
            try {
                Class<?> documentBuilder = Class.forName("com.plutext.merge.ProcessAltChunk");
                Method[] methods = documentBuilder.getMethods();
                Method method = null;
                for (int j = 0; j < methods.length; ++j) {
                    System.out.println(methods[j].getName());
                    if (!methods[j].getName().equals("process")) continue;
                    method = methods[j];
                    break;
                }
                if (method == null) {
                    throw new NoSuchMethodException();
                }
                return (WordprocessingMLPackage)method.invoke(null, clonePkg);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                log.warn("* Skipping altChunk of type docx ");
                return clonePkg;
            }
            catch (ClassNotFoundException e) {
                this.extensionMissing(e);
                return clonePkg;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                log.warn("* Skipping altChunk of type docx ");
                return clonePkg;
            }
            catch (NoSuchMethodException e) {
                this.extensionMissing(e);
                return clonePkg;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                log.warn("* Skipping altChunk of type docx ");
                return clonePkg;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                log.warn("* Skipping altChunk of type docx ");
                return clonePkg;
            }
        }
        return clonePkg;
    }

    private void extensionMissing(Exception e) {
        log.warn("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n");
        log.warn("* Skipping altChunk of type docx ");
        log.warn("* You don't appear to have the MergeDocx paid extension,");
        log.warn("* which is necessary to merge docx, or process altChunk.");
        log.warn("* Purchases of this extension support the docx4j project.");
        log.warn("* Please email sales@plutext.com or visit www.plutext.com if you want to buy it.");
    }

    private String toString(ByteBuffer bb) throws UnsupportedEncodingException {
        byte[] bytes = null;
        bytes = new byte[bb.limit()];
        bb.get(bytes);
        return new String(bytes, "UTF-8");
    }
}

