/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.util;

import java.util.Set;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FopConfigUtil {
    protected static Logger log = LoggerFactory.getLogger(FopConfigUtil.class);

    public static String createDefaultConfiguration(Mapper fontMapper, Set<String> fontsInUse) throws Docx4JException {
        StringBuilder buffer = new StringBuilder(10240);
        buffer.append("<fop version=\"1.0\"><strict-configuration>true</strict-configuration>");
        buffer.append("<renderers><renderer mime=\"application/pdf\">");
        buffer.append("<fonts>");
        FopConfigUtil.declareFonts(fontMapper, fontsInUse, buffer);
        buffer.append("</fonts></renderer></renderers></fop>");
        if (log.isDebugEnabled()) {
            log.debug("\nUsing fop config:\n " + buffer.toString() + "\n");
        }
        return buffer.toString();
    }

    protected static void declareFonts(Mapper fontMapper, Set<String> fontsInUse, StringBuilder result) {
        for (String fontName : fontsInUse) {
            PhysicalFont pf = fontMapper.getFontMappings().get(fontName);
            if (pf == null) {
                log.error("Document font " + fontName + " is not mapped to a physical font!");
                continue;
            }
            String subFontAtt = "";
            if (pf.getEmbedFontInfo().getSubFontName() != null) {
                subFontAtt = " sub-font=\"" + pf.getEmbedFontInfo().getSubFontName() + "\"";
            }
            result.append("<font embed-url=\"" + pf.getEmbeddedFile() + "\"" + subFontAtt + ">");
            FontTriplet fontTriplet = (FontTriplet)pf.getEmbedFontInfo().getFontTriplets().get(0);
            FopConfigUtil.addFontTriplet(result, fontTriplet);
            result.append("</font>");
            PhysicalFont pfVariation = PhysicalFonts.getBoldForm(pf);
            if (pfVariation == null) {
                log.debug(fontName + " no bold form");
            } else {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                FopConfigUtil.addFontTriplet(result, pf.getName(), "normal", "bold");
                result.append("</font>");
            }
            pfVariation = PhysicalFonts.getBoldItalicForm(pf);
            if (pfVariation == null) {
                log.debug(fontName + " no bold italic form");
            } else {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                FopConfigUtil.addFontTriplet(result, pf.getName(), "italic", "bold");
                result.append("</font>");
            }
            pfVariation = PhysicalFonts.getItalicForm(pf);
            if (pfVariation == null) {
                log.debug(fontName + " no italic form");
                continue;
            }
            result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
            FopConfigUtil.addFontTriplet(result, pf.getName(), "italic", "normal");
            result.append("</font>");
        }
    }

    protected static void addFontTriplet(StringBuilder result, FontTriplet fontTriplet) {
        FopConfigUtil.addFontTriplet(result, fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight()));
    }

    protected static void addFontTriplet(StringBuilder result, String familyName, String style, String weight) {
        result.append("<font-triplet name=\"");
        result.append(familyName);
        result.append('\"');
        result.append(" style=\"");
        result.append(style);
        result.append('\"');
        result.append(" weight=\"");
        result.append(weight);
        result.append("\"/>");
    }

    protected static String weightToCSS2FontWeight(int i) {
        return i >= 700 ? "bold" : "normal";
    }
}

