/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.AbstractVisitorExporterGenerator;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.model.images.WordXmlPictureE10;
import org.docx4j.model.images.WordXmlPictureE20;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLExporterVisitorGenerator
extends AbstractVisitorExporterGenerator<HTMLConversionContext> {
    public static final AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<HTMLConversionContext> GENERATOR_FACTORY = new AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<HTMLConversionContext>(){

        @Override
        public AbstractVisitorExporterGenerator<HTMLConversionContext> createInstance(HTMLConversionContext conversionContext, Document document, org.w3c.dom.Node parentNode) {
            return new HTMLExporterVisitorGenerator(conversionContext, document, parentNode);
        }
    };

    private HTMLExporterVisitorGenerator(HTMLConversionContext conversionContext, Document document, org.w3c.dom.Node parentNode) {
        super(conversionContext, document, parentNode);
    }

    @Override
    protected AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<HTMLConversionContext> getFactory() {
        return GENERATOR_FACTORY;
    }

    @Override
    protected Element createNode(Document doc, int nodeType) {
        switch (nodeType) {
            case 1: {
                return this.document.createElement("p");
            }
            case 2: {
                return this.document.createElement("span");
            }
        }
        return null;
    }

    @Override
    protected DocumentFragment createImage(int imgType, HTMLConversionContext conversionContext, Object anchorOrInline) {
        switch (imgType) {
            case 1: {
                return WordXmlPictureE10.createHtmlImgE10(conversionContext, anchorOrInline);
            }
            case 2: {
                return WordXmlPictureE20.createHtmlImgE20(conversionContext, anchorOrInline);
            }
        }
        return null;
    }

    @Override
    protected Element handlePPr(HTMLConversionContext conversionContext, PPr pPrDirect, boolean sdt, Element currentParent) {
        Element ret = currentParent;
        if (pPrDirect != null) {
            Emulator.ResultTriple triple;
            String pStyleVal = null;
            if (pPrDirect.getPStyle() != null && pPrDirect.getPStyle().getVal() != null) {
                pStyleVal = pPrDirect.getPStyle().getVal();
                Tree<StyleTree.AugmentedStyle> pTree = conversionContext.getStyleTree().getParagraphStylesTree();
                Node<StyleTree.AugmentedStyle> asn = pTree.get(pStyleVal);
                currentParent.setAttribute("class", StyleTree.getHtmlClassAttributeValue(pTree, asn));
            }
            boolean ignoreBorders = true;
            StringBuilder inlineStyle = new StringBuilder();
            HtmlCssHelper.createCss(conversionContext.getWmlPackage(), pPrDirect, inlineStyle, ignoreBorders);
            if (!inlineStyle.toString().equals("")) {
                currentParent.setAttribute("style", inlineStyle.toString());
            }
            String numberText = null;
            String numId = null;
            String levelId = null;
            if (pPrDirect.getNumPr() != null) {
                numId = pPrDirect.getNumPr().getNumId() == null ? null : pPrDirect.getNumPr().getNumId().getVal().toString();
                String string = levelId = pPrDirect.getNumPr().getIlvl() == null ? null : pPrDirect.getNumPr().getIlvl().getVal().toString();
            }
            if ((triple = Emulator.getNumber(conversionContext.getWmlPackage(), pStyleVal, numId, levelId)) == null) {
                this.getLog().debug("computed number ResultTriple was null");
            } else if (triple.getBullet() != null) {
                numberText = "\u2022  ";
            } else if (triple.getNumString() == null) {
                this.getLog().error("computed NumString was null!");
                numberText = "?";
            } else {
                numberText = triple.getNumString() + " ";
            }
            if (numberText != null) {
                currentParent.appendChild(this.document.createTextNode(numberText + " "));
            }
        }
        return ret;
    }

    @Override
    protected void handleRPr(HTMLConversionContext conversionContext, PPr pPrDirect, RPr rPrDirect, Element currentParent) {
        if (rPrDirect.getRStyle() != null) {
            String rStyleVal = rPrDirect.getRStyle().getVal();
            Tree<StyleTree.AugmentedStyle> cTree = conversionContext.getStyleTree().getCharacterStylesTree();
            Node<StyleTree.AugmentedStyle> asn = cTree.get(rStyleVal);
            if (asn == null) {
                this.getLog().warn("No style node for: " + rStyleVal);
            } else {
                currentParent.setAttribute("class", StyleTree.getHtmlClassAttributeValue(cTree, asn));
            }
        }
        StringBuilder inlineStyle = new StringBuilder();
        HtmlCssHelper.createCss(conversionContext.getWmlPackage(), rPrDirect, inlineStyle);
        if (!inlineStyle.toString().equals("")) {
            currentParent.setAttribute("style", inlineStyle.toString());
        }
    }
}

