% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_gsva}
\alias{KO_gsva}
\title{Perform Gene Set Variation Analysis}
\usage{
KO_gsva(
  reporter_res,
  verbose = TRUE,
  method = "wilcox.test",
  p.adjust.method = "BH",
  ...
)
}
\arguments{
\item{reporter_res}{reporter_res}

\item{verbose}{verbose}

\item{method}{see \code{\link{ko.test}}}

\item{p.adjust.method}{p.adjust.method}

\item{...}{additional parameters to \code{\link[GSVA]{gsva}}}
}
\value{
enrich_res
}
\description{
Perform Gene Set Variation Analysis
}
\examples{
\donttest{
## use `gsva` from the `GSVA` package.
if (requireNamespace("GSVA")) {
  data("reporter_score_res")
  gsva_res <- KO_gsva(reporter_score_res, p.adjust.method = "none")
}
}
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsea}()},
\code{\link{KO_padog}()},
\code{\link{KO_safe}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
