% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{nQ}
\alias{nQ}
\title{E-step function Q}
\usage{
nQ(theta, euy_curr, vuy_curr, M, M_bdiag, y, V, VCNs, nObs, dW)
}
\arguments{
\item{theta}{p-dimensional vector parameter.}

\item{euy_curr}{current value of the conditional expectation \eqn{E[u \vert y]}{E[u|y]} of u given y,
where u and y are the latent and observed states respectively.}

\item{vuy_curr}{current value of the conditional variance \eqn{V[u \vert y]}{V[u|y]} of u given y,
where u and y are the latent and observed states respectively.}

\item{M}{A \eqn{n \times K}{n by K} dimensional (design) matrix.}

\item{M_bdiag}{A\eqn{n \times Jp}{n by J*p} dimensional block-diagonal design matrix.
Each j-th block (\eqn{j = 1,\dots,J}{j = 1,..,J}) is a \eqn{n_j \times p}{n_j by p} dimensional design matrix for the j-th clone.}

\item{y}{n-dimensional vector of the time-adjacent cellular increments}

\item{V}{A \eqn{p \times K}{p by K} dimensional net-effect matrix.}

\item{VCNs}{A n-dimensional vector including values of the vector copy number corresponding to the cell counts of y.}

\item{nObs}{A K-dimensional vector including the frequencies of each clone k (\eqn{k = 1,\dots,K}{k = 1,..,K}).}

\item{dW}{p-dimensional list of the partial derivatives of W w.r.t. theta.}
}
\value{
The current value of the negative E-step function -Q.
}
\description{
Negative E-step function -Q of the expectation-maximization algorithm
}
\keyword{internal}
