% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultExportManager.R
\name{ResultExportManager}
\alias{ResultExportManager}
\title{Result Set Export Manager}
\description{
EXPERIMENTAL - this feature is still in design stage and it is not reccomended that you implement this for your
package at this stage.
Utility for simplifying export of results to files from sql queries

Note that this utility is not strictly thread safe though seperate processes can export separate tables
without issue. When exporting a the same table across multiple threads primary key checks may create
issues.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{exportDir}}{direcotry path to export files to
Init}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResultExportManager-new}{\code{ResultExportManager$new()}}
\item \href{#method-ResultExportManager-getTableSpec}{\code{ResultExportManager$getTableSpec()}}
\item \href{#method-ResultExportManager-getMinColValues}{\code{ResultExportManager$getMinColValues()}}
\item \href{#method-ResultExportManager-checkRowTypes}{\code{ResultExportManager$checkRowTypes()}}
\item \href{#method-ResultExportManager-listTables}{\code{ResultExportManager$listTables()}}
\item \href{#method-ResultExportManager-checkPrimaryKeys}{\code{ResultExportManager$checkPrimaryKeys()}}
\item \href{#method-ResultExportManager-exportDataFrame}{\code{ResultExportManager$exportDataFrame()}}
\item \href{#method-ResultExportManager-exportQuery}{\code{ResultExportManager$exportQuery()}}
\item \href{#method-ResultExportManager-getManifestList}{\code{ResultExportManager$getManifestList()}}
\item \href{#method-ResultExportManager-writeManifest}{\code{ResultExportManager$writeManifest()}}
\item \href{#method-ResultExportManager-clone}{\code{ResultExportManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-new}{}}}
\subsection{Method \code{new()}}{
Create a class for exporting results from a study in a standard, consistend manner
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$new(
  tableSpecification,
  exportDir,
  minCellCount = getOption("ohdsi.minCellCount", default = 5),
  databaseId = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tableSpecification}}{Table specification data.frame}

\item{\code{exportDir}}{Directory files are being exported to}

\item{\code{minCellCount}}{Minimum cell count - reccomended that you set with
options("ohdsi.minCellCount" = count) in all R projects. Default is 5}

\item{\code{databaseId}}{database identifier - required when exporting according to many specs
get table spec}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-getTableSpec"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-getTableSpec}{}}}
\subsection{Method \code{getTableSpec()}}{
Get specification of table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$getTableSpec(exportTableName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{exportTableName}}{table name
Get min col values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-getMinColValues"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-getMinColValues}{}}}
\subsection{Method \code{getMinColValues()}}{
Columns to convert to minimum for a given table name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$getMinColValues(rows, exportTableName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{data.frame of rows}

\item{\code{exportTableName}}{stering table name - must be defined in spec
Check row types}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-checkRowTypes"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-checkRowTypes}{}}}
\subsection{Method \code{checkRowTypes()}}{
Check types of rows before exporting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$checkRowTypes(rows, exportTableName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{data.frame of rows to export}

\item{\code{exportTableName}}{table name
List tables}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-listTables"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-listTables}{}}}
\subsection{Method \code{listTables()}}{
list all tables in schema
Check primary keys of exported data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$listTables()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-checkPrimaryKeys"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-checkPrimaryKeys}{}}}
\subsection{Method \code{checkPrimaryKeys()}}{
Checks to see if the rows conform to the valid primary keys
If the same table has already been checked in the life of this object set
"invalidateCache" to TRUE as the keys will be cached in a temporary file
on disk.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$checkPrimaryKeys(
  rows,
  exportTableName,
  invalidateCache = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{data.frame to export}

\item{\code{exportTableName}}{Table name (must be in spec)}

\item{\code{invalidateCache}}{logical - if starting a fresh export use this to delete cache of primary keys
Export data frame}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-exportDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-exportDataFrame}{}}}
\subsection{Method \code{exportDataFrame()}}{
This method is intended for use where exporting a data.frame and not a query from a rdbms table
For example, if you perform a transformation in R this method will check primary keys, min cell counts and
data types before writing the file to according to the table spec
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$exportDataFrame(rows, exportTableName, append = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{Rows to export}

\item{\code{exportTableName}}{Table name}

\item{\code{append}}{logical - if true will append the result to a file, otherwise the file will be overwritten
Export Data table with sql query}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-exportQuery"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-exportQuery}{}}}
\subsection{Method \code{exportQuery()}}{
Writes files in batch to stop overflowing system memory
Checks primary keys on write
Checks minimum cell count
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$exportQuery(
  connection,
  sql,
  exportTableName,
  transformFunction = NULL,
  transformFunctionArgs = list(),
  append = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connection}}{DatabaseConnector connection instance}

\item{\code{sql}}{OHDSI sql string to export tables}

\item{\code{exportTableName}}{Name of table to export (in snake_case format)}

\item{\code{transformFunction}}{(optional) transformation of the data set callback.
must take two paramters - rows and pos

\if{html}{\out{<div class="sourceCode">}}\preformatted{   Following this transformation callback, results will be verified against data model,
   Primary keys will be checked and minCellValue rules will be enforced
}\if{html}{\out{</div>}}}

\item{\code{transformFunctionArgs}}{arguments to be passed to the transformation function}

\item{\code{append}}{Logical add results to existing file, if FALSE (default) creates a new file and removes primary
key validation cache}

\item{\code{...}}{extra parameters passed to sql
get manifest list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-getManifestList"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-getManifestList}{}}}
\subsection{Method \code{getManifestList()}}{
Create a meta data set for each collection of result files with sha256 has for all files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$getManifestList(
  packageName = NULL,
  packageVersion = NULL,
  migrationsPath = NULL,
  migrationRegexp = .defaultMigrationRegexp
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{packageName}}{if an R analysis package, specify the name}

\item{\code{packageVersion}}{if an analysis package, specify the version}

\item{\code{migrationsPath}}{path to sql migrations (use top level folder (e.g. sql/sql_server/migrations)}

\item{\code{migrationRegexp}}{(optional) regular expression to search for sql files. It is not reccomended to change the default.
Write manifest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-writeManifest"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-writeManifest}{}}}
\subsection{Method \code{writeManifest()}}{
Write manifest json
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$writeManifest(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{@seealso getManifestList}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultExportManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResultExportManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultExportManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
