% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adf_est.R
\name{adf_est.class}
\alias{adf_est.class}
\title{An S4 class to represent the estimation of the Angular Dependence Function}
\usage{
adf_est.class(
  dataexp,
  w,
  method,
  q,
  qalphas,
  k,
  constrained,
  tol,
  par_init,
  interval,
  adf
)
}
\description{
An S4 class to represent the estimation of the Angular Dependence Function
}
\section{Slots}{

\describe{
\item{\code{dataexp}}{A matrix containing the data on standard exponential margins.}

\item{\code{w}}{Sequence of rays between \code{0} and \code{1}. Default is \code{NULL}, where a pre-defined grid is used.}

\item{\code{method}}{String that indicates which method is used for the estimation of the angular dependence function. Must either be \code{"hill"}, to use the Hill estimator \insertCite{Hill1975}{ReturnCurves}, or \code{"cl"} to use the smooth estimator based on Bernstein-Bezier polynomials estimated by composite maximum likelihood.}

\item{\code{q}}{\loadmathjax{} Marginal quantile used to define the threshold \mjeqn{u_\omega}{} of the min-projection variable \mjeqn{T^1}{} at ray \mjeqn{\omega}{} \mjeqn{\left(t^1_\omega = t_\omega - u_\omega | t_\omega > u_\omega\right)}{}, and/or Hill estimator \insertCite{Hill1975}{ReturnCurves}. Default is \code{0.95}.}

\item{\code{qalphas}}{A vector containing the marginal quantiles used for the Heffernan and Tawn conditional extremes model \insertCite{HeffernanTawn2004}{ReturnCurves} for each variable, if \code{constrained = TRUE}. Default is \code{rep(0.95, 2)}.}

\item{\code{k}}{Polynomial degree for the Bernstein-Bezier polynomials used for the estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default is \code{7}.}

\item{\code{constrained}}{Logical. If \code{FALSE} (Default) no knowledge of the conditional extremes parameters is incorporated in the angular dependence function estimation.}

\item{\code{tol}}{Convergence tolerance for the composite maximum likelihood procedure. Success is declared when the difference of log-likelihood values between iterations does not exceed this value. Default is \code{0.0001}.}

\item{\code{par_init}}{Initial values for the parameters \mjeqn{\beta}{} of the Bernstein-Bezier polynomials used for estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default is \code{rep(0, k-1)}.}

\item{\code{interval}}{Maximum likelihood estimates \mjeqn{\hat{\alpha}^1_{x\mid y}}{} and \mjeqn{\hat{\alpha}^1_{y\mid x}}{} from the conditional extremes model if \code{constrained = TRUE}.}

\item{\code{adf}}{A vector containing the estimates of the angular dependence function.}
}}

\references{
\insertAllCited{}
}
\keyword{internal}
