% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_uncertainty.R
\docType{methods}
\name{plot,rc_unc.class,ANY-method}
\alias{plot,rc_unc.class,ANY-method}
\alias{plot,rc_unc.class}
\title{Visualisation of the Uncertainty of the Return Curve estimates}
\usage{
\S4method{plot}{rc_unc.class,ANY}(x, which = c("rc", "median", "mean", "all"))
}
\arguments{
\item{x}{An instance of an S4 class produced by \code{\link{rc_unc}}.}

\item{which}{String that indicates which return curve estimates to show. Must either be \code{"rc"} (Default), \code{"median"}, \code{"mean"} or \code{"all"}.}
}
\value{
A ggplot object showing:
\item{\code{which = "rc"}}{Plots the estimated Return Curve and its uncertainty.}
\item{\code{which = "median"}}{Plots the median estimates of the Return Curve and its uncertainty.}
\item{\code{which = "mean"}}{Plots the mean estimates of the Return Curve and its uncertainty.}
\item{\code{which = "all"}}{Plots all the estimated Return Curve, the median and mean estimates of the Return Curve, and its uncertainty.}
}
\description{
Plot method for an S4 object returned by \code{\link{rc_unc}}.
}
\keyword{internal}
