% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.rfpred.norm.R
\name{mice.impute.rfpred.norm}
\alias{mice.impute.rfpred.norm}
\title{Multiple imputation using chained random forests: RfPred.Norm}
\usage{
mice.impute.rfpred.norm(
  y,
  ry,
  x,
  wy = NULL,
  num.trees.cont = 10,
  pre.boot = TRUE,
  num.threads = NULL,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed.}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{num.trees.cont}{Number of trees to build for continuous variables.
The default is \code{num.trees = 10}.}

\item{pre.boot}{If \code{TRUE}, bootstrapping prior to imputation will be
performed to perform 'proper' multiple imputation, for accommodating sampling
variation in estimating population regression parameters
(see Shah et al. 2014).
It should be noted that if \code{TRUE}, this option is in effect even if the
number of trees is set to one.}

\item{num.threads}{Number of threads for parallel computing. The default is
\code{num.threads = NULL} and all the processors available can be used.}

\item{...}{Other arguments to pass down.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}.
}
\description{
Please note that functions with names starting with "mice.impute" are
exported to be visible for the mice sampler functions. Please do not call
these functions directly unless you know exactly what you are doing.

For continuous variables only.

This function is for \code{RfPred.Norm}
multiple imputation method, adapter for \code{mice} samplers.
In the \code{mice()} function, set \code{method = "rfpred.norm"} to call it.

The function performs multiple imputation based on normality assumption using
out-of-bag mean squared error as the estimate for variance.
}
\details{
\code{RfPred.Norm} imputation sampler.
}
\examples{
# Users can set method = "rfpred.norm" in call to mice to use this method
data("airquality")
impObj <- mice(airquality, method = "rfpred.norm", m = 5,
maxit = 5, maxcor = 1.0, eps = .Machine$double.xmin, printFlag = FALSE)

}
\references{
Shah, Anoop D., et al. "Comparison of random forest and parametric
imputation models for imputing missing data using MICE: a CALIBER study."
American journal of epidemiology 179.6 (2014): 764-774.
}
\author{
Shangzhi Hong
}
