% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsplot.r
\name{plot.fts}
\alias{plot.fts}
\title{Functional Time Series Visualization Tools Using Plotly}
\usage{
\method{plot}{fts}(x, npts = 100, type = "line", main = NULL,
  ylab = NULL, xlab = NULL, tlab = NULL, var = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{fts}}}

\item{npts}{number of points to evaluate functional object at}

\item{type}{the type of plot to be displayed where possible types are:
\itemize{
\item \code{"line"} plot the \code{\link{fts}} elements in a line plot (default)
\item \code{"heatmap"} plot the \code{\link{fts}} elements in a heat map
\item \code{"3Dsurface"} plot the \code{\link{fts}} elements as a surface
\item \code{"3Dline"} plot the \code{\link{fts}} elements in a three-dimensional line plot
}}

\item{main}{the main title}

\item{ylab}{the y-axis label}

\item{xlab}{the x-axis label}

\item{tlab}{the time-axis label}

\item{var}{an integer specifying the variable number to plot if \code{type="3Dsurface"} or \code{type="3Dline"}}

\item{...}{arguments to be passed to methods, such as graphical parameters.}
}
\description{
This is a plotting method for univariate or multivariate functional time series (\code{\link{fts}}). This method is designed to help the user visualize
\code{\link{fts}} data using a variety of techniques that use plotly.
}
\note{
for a multivariate example, see the examples in \code{\link{fssa}}
}
\examples{

\dontrun{
require(fda)
require(Rfssa)
data(Callcenter) # Read data
u=seq(0,1,length.out=240) # Define domain of functional data
d=12 # number of basis elements
basis=create.bspline.basis(rangeval = c(0,1),nbasis = d) # create basis object
smooth.calls=smooth.basis(u, matrix(nrow=240,ncol=365,Callcenter$calls), basis)
Y=fts(smooth.calls$fd) # create functional time series
plot(Y,type = "heatmap")
plot(Y,type = "line",var = 1)
plot(Y,type = "3Dsurface",var = 1)
plot(Y,type = "3Dline",var = 1)
}

}
