% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_power_cont.R
\name{gof_power_cont}
\alias{gof_power_cont}
\title{Find the power of various gof tests for continuous data.}
\usage{
gof_power_cont(
  pnull,
  rnull,
  ralt,
  param_alt,
  w = function(x) -99,
  phat = function(x) -99,
  TS,
  TSextra = NA,
  alpha = 0.05,
  Range = c(-Inf, Inf),
  B = c(1000, 1000),
  nbins = c(100, 10),
  rate = 0,
  maxProcessors,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{rnull}{function to generate data under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{w}{(Optional) function to calculate weights, returns -99 if no weights}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters aare estimated}

\item{TS}{user supplied function to find test statistics, if any}

\item{TSextra}{=NA, list provided to TS}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any}

\item{B}{=c(1000, 1000), number of simulation runs to find power and null distribution}

\item{nbins}{=c(100,10), number of bins for chi square tests.}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{maxProcessors}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{=TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}
}
\value{
A numeric matrix of power values.
}
\description{
Find the power of various gof tests for continuous data.
}
