% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_runif.R
\name{st.runif}
\alias{st.runif}
\title{Generate Random Samples from Uniform Distribution on Stiefel Manifold}
\usage{
st.runif(n, p, r, rtype = c("list", "array"))
}
\arguments{
\item{n}{number of samples to be generated.}

\item{p}{original dimension (of the ambient space).}

\item{r}{dimension of the frame.}

\item{rtype}{return type; either 3d-array (\code{"array"}) or list (\code{"list"}).}
}
\value{
a length \eqn{n} list or 3d array of size \eqn{(p,r,n)}.
}
\description{
It generates \eqn{n} random samples from Stiefel manifold \eqn{St(p,r)} 
according to the procedure described in the reference.
}
\examples{
## let's simply draw 3 times from St(10,5)
dat3 = st.runif(3, 10, 5, rtype="array")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
image(dat3[,,1], main="sample 1")
image(dat3[,,2], main="sample 2")
image(dat3[,,3], main="sample 3")
par(opar)

}
\references{
\insertRef{chikuse_statistics_2003}{RiemStiefel}
}
