% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_interp.R
\name{riem.interp}
\alias{riem.interp}
\title{Geodesic Interpolation}
\usage{
riem.interp(riemobj, t = 0.5, geometry = c("intrinsic", "extrinsic"))
}
\arguments{
\item{riemobj}{a S3 \code{"riemdata"} class for \eqn{2} manifold-valued data where the first object is the starting point.}

\item{t}{a scalar in \eqn{(0,1)} for which the interpolation is taken.}

\item{geometry}{(case-insensitive) name of geometry; either geodesic (\code{"intrinsic"}) or embedded (\code{"extrinsic"}) geometry.}
}
\value{
an interpolated object in matrix representation on \eqn{\mathcal{M}}.
}
\description{
Given 2 observations \eqn{X_1, X_2 \in \mathcal{M}}, find the interpolated 
point of a geodesic \eqn{\gamma(t)} for \eqn{t \in (0,1)} which 
assumes two endpoints \eqn{\gamma(0)=X_1} and \eqn{\gamma(1)=X_2}.
}
\examples{
#-------------------------------------------------------------------
#       Geodesic Interpolation between (1,0) and (0,1) in S^1
#-------------------------------------------------------------------
## PREPARE DATA
sp.start = c(1,0)
sp.end   = c(0,1)
sp.data  = wrap.sphere(rbind(sp.start, sp.end))

## FIND THE INTERPOLATED POINT AT "t=0.25"
mid.int = as.vector(riem.interp(sp.data, t=0.25, geometry="intrinsic"))
mid.ext = as.vector(riem.interp(sp.data, t=0.25, geometry="extrinsic"))

## VISUALIZE
#  Prepare Lines and Points
thetas  = seq(from=0, to=pi/2, length.out=100)
quarter = cbind(cos(thetas), sin(thetas))
pic.pts = rbind(sp.start, mid.int, mid.ext, sp.end)
pic.col = c("black","red","green","black")

# Draw
opar <- par(no.readonly=TRUE)
par(pty="s")
plot(quarter, main="two interpolated points at t=0.25",
     xlab="x", ylab="y", type="l")
points(pic.pts, col=pic.col, pch=19)
text(mid.int[1]-0.1, mid.int[2], "intrinsic", col="red")
text(mid.ext[1]-0.1, mid.ext[2], "extrinsic", col="green")
par(opar)

}
\concept{basic}
